/*==============================================================================
*
*       filename        okFunc.c
*       purpose         API for okapi32.dll exam (Ok series image cards)
*       language        Microsoft Visual C 5.0
*       author          He Peng
*       date            00-8-20
*-----------------------
*       modify by       He Peng
*       purpose         
*       language        Microsoft Visual C 5.0 
*       date            00-10-16
*
*-----------------------
*
*		Copyright (C).  All Rights Reserved.
*
*
*==============================================================================*/

#include<stdio.h>
#include<stdlib.h>
#include<conio.h>
#include <dos.h>
#include <memory.h>
#include <time.h>

#include<windows.h>

#include"resource.h"

#include "okapi32.h"


//---------------

#define		NUMINFILE		30
#define		SOURCENUMBER	3

//----global variables for board--------
HANDLE		hBoard;
BYTE		bActive=0;
short		total=2;
long		iCurrUsedNo=-1;//	

short		iNumImage=NUMINFILE;

short		bScrnCenter=1; //centerize
long		lScrnOffset;
short		sampwidth,sampheight;

short		bMaskMode=0; // mask disable

LPSTR		seqfile="ok.seq";
DWORD		dwMaxMemSize=30*1024*1024;
long		dwBufSize;

TARGET		CaptureTarget=SCREEN;	//ɼĿ
short		CaptureStart=1;			//ɼʼ֡
short		CaptureEnd=1;			//ɼ֡


LPBITMAPINFOHEADER	lpbi;
LPSTR				lpdib;
LPSTR				lpMemory;
BLOCKINFO			blkinfo;


BOOL				bDispToScreen=1;

//----local functions-------------------------------------

int	PrintReport(HWND hWnd, LPBITMAPINFOHEADER lpbi, LPSTR lpdib);

long SetBitmapHeader(LPBITMAPINFOHEADER lpbi,short width,short height, short bits, short form);
long SetDataToDIB(TARGET src, short start, LPBITMAPINFOHEADER lpbi, LPBYTE lpdib);
long GetTargetSize(HANDLE hBoard, TARGET tgt, short *width, short *heigth);

BOOL GetBitmapData(HANDLE hBoard, TARGET tgt, short start, LPBITMAPINFOHEADER lpbi, LPSTR lpdib);
BOOL GetBitmapHeader(HANDLE hBoard, TARGET src, LPBITMAPINFOHEADER lpbi);

HANDLE	OpenCard(HWND hWnd);
BOOL GetBitmapHeader(HANDLE hBoard, TARGET src, LPBITMAPINFOHEADER lpbi);
void EnableItem(HWND hWnd, int iMenuID, BOOL bEnable);
void DisplayDIBInfo(HWND hwnd);
void SetPaletteToWnd(HDC hDC);
HPALETTE MakeLogPalette(short iBits, short rgbForm);

//----------------------- window parts----------

HWND	hwnd;
HANDLE	hInst;
HANDLE  hAccTable;  // handle to accelerator table 
BOOL InitApplication(HINSTANCE);
BOOL InitInstance(HINSTANCE, int);

APIENTRY MainWndProc(HWND,UINT,WPARAM,LPARAM );
extern BOOL APIENTRY IddSource(HWND hDlg,unsigned message,UINT wParam,LONG lParam);
extern BOOL APIENTRY IddVideoParam(HWND hDlg,unsigned message,UINT wParam,LONG lParam);
extern BOOL APIENTRY IddMask(HWND hDlg,unsigned message,UINT wParam,LONG lParam);
extern BOOL APIENTRY IddCSetup(HWND hDlg,unsigned message,UINT wParam,LONG lParam);
extern BOOL APIENTRY IddOther(HWND hDlg,unsigned message,UINT wParam,LONG lParam);
extern BOOL APIENTRY IddOutLut(HWND hDlg,unsigned message,UINT wParam,LONG lParam);
extern BOOL APIENTRY IddTo8Bit(HWND hDlg,unsigned message,UINT wParam,LONG lParam);
extern BOOL APIENTRY SelectDlgProc(HWND hDlg,unsigned message,UINT wParam,LONG lParam);

BOOL CALLBACK BeginCapture(HANDLE hBoard);
BOOL CALLBACK BackDisplay(HANDLE hBoard,long no);
BOOL CALLBACK SetToScreen(HANDLE hBoard,long no);
BOOL CALLBACK EndCapture(HANDLE hBoard);
long GetFrameSize(HANDLE hBoard);
void ScreenDisplay(void);


/****************************************************************************

    FUNCTION: WinMain(HANDLE, HANDLE, LPSTR, int)

    PURPOSE: calls initialization function, processes message loop

****************************************************************************/
int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HINSTANCE hInstance;
HINSTANCE hPrevInstance;
LPSTR lpCmdLine;
int nCmdShow;
{
    MSG msg;


    if (!hPrevInstance)
    if (!InitApplication(hInstance))
        return (FALSE);

    if (!InitInstance(hInstance, nCmdShow))
        return (FALSE);

    hAccTable = LoadAccelerators(hInstance, "OkDemoAcc");
    while (GetMessage(&msg, NULL, 0,0)) {
		// Only translate message if it is not an accelerator message 
		if (!TranslateAccelerator(hwnd, hAccTable, &msg) ) {//|
		    	//!TranslateMDISysAccel (hwndMDIClient, &msg) ) {
		    TranslateMessage(&msg);
		    DispatchMessage(&msg);
		}
	}
    return (msg.wParam);
}


/****************************************************************************

    FUNCTION: InitApplication(HANDLE)

    PURPOSE: Initializes window data and registers window class

****************************************************************************/

BOOL InitApplication(hInstance)
HINSTANCE hInstance;
{
    WNDCLASS  wc;

    wc.style = CS_VREDRAW | CS_HREDRAW |CS_BYTEALIGNCLIENT ;
    wc.lpfnWndProc = MainWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon(hInstance, "OkFuncIcon");//IDI_APPLICATION);
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
    wc.lpszMenuName =  "OkFuncMenu";
    wc.lpszClassName = "OkFuncWClass";


    return (RegisterClass(&wc));
}


/****************************************************************************

    FUNCTION:  InitInstance(HANDLE, int)

    PURPOSE:  Saves instance handle and creates main window

****************************************************************************/

BOOL InitInstance(hInstance, nCmdShow)
    HINSTANCE          hInstance;
    int             nCmdShow;
{
	char	string[100];
    hInst = hInstance;

	LoadString(hInst, IDS_PROGRAMNAME, string,100);

    hwnd = CreateWindow("OkFuncWClass",
                        string,//"Demo Programm for Ok Image Device",
                        WS_OVERLAPPEDWINDOW,
                        CW_USEDEFAULT,
                        CW_USEDEFAULT,
                        CW_USEDEFAULT,
                        CW_USEDEFAULT,
                        NULL,
                        NULL,
                        hInstance,
                        NULL
                       );

    if (!hwnd)
        return (FALSE);

    ShowWindow(hwnd, nCmdShow|SW_MAXIMIZE);
	//SendMessage(hwnd,WM_SYSCOMMAND,SC_MAXIMIZE,0);


    return (TRUE);

}

//****************************************************************************/
APIENTRY MainWndProc(hWnd, message, wParam, lParam)
HWND hWnd;
UINT message;
WPARAM wParam;
LPARAM lParam;
{
    switch (message)
    {
        case WM_CREATE:             // message: create window
			//½
			hBoard=OpenCard(hWnd);
            break;
        case WM_CLOSE:				//close window
			//ر
			okCloseBoard(hBoard); 
			GlobalFree((HGLOBAL)lpbi);  
			lpdib=0;
        case WM_DESTROY:
			//˳
			PostQuitMessage(0);
			break;
		case WM_MOUSEMOVE: 
			break;
		case WM_INITMENUPOPUP: //drop down menu
			//ʾ˵ֹͣɼ
			if(bActive)
				SendMessage(hWnd,WM_COMMAND,IDM_FREEZE,0);
			break;

/*		case WM_SYSCOMMAND:
			//С
			DefWindowProc(hWnd, message, wParam, lParam);
			if(wParam==SC_MINIMIZE || wParam==SC_RESTORE ) {
				if(wParam==SC_MINIMIZE)
					okStopCapture(hBoard);
				InvalidateRect(NULL,NULL,TRUE);
			}
			break;*/
		case WM_PAINT: 
			//ػ
		{
			PAINTSTRUCT	ps;
			HDC			hDC;
			LPBITMAPINFOHEADER	lpBI;
			LPBYTE				lpDIB;

			hDC=BeginPaint(hWnd,&ps);
			SetPaletteToWnd(hDC);

			lpBI=lpbi;
			lpDIB=lpdib;
			
			if(lpBI) {
				RECT	rect;	POINT	pt;

				GetClientRect(hWnd,&rect);
				if(lpBI->biHeight>rect.bottom)
					rect.top=lpBI->biHeight-rect.bottom;
				else
					rect.top=0;

				pt.x=LOWORD(lScrnOffset);
				pt.y=HIWORD(lScrnOffset);
				ClientToScreen(hWnd,&pt);
				//adjust x abs. offset to 4 align
				pt.x= pt.x%4 ? pt.x+4-pt.x%4 : pt.x;
				ScreenToClient(hWnd,&pt);

				SetDIBitsToDevice(hDC,pt.x,pt.y,
					lpBI->biWidth,lpBI->biHeight,				
					0,rect.top, 
					0,lpBI->biHeight,
					lpDIB,
					(LPBITMAPINFO)lpBI,DIB_RGB_COLORS);
				
			}

			EndPaint(hWnd,&ps);
			break;
		}//end paint
        case WM_COMMAND:
			if(bActive)
				okStopCapture(hBoard);	
			switch (LOWORD(wParam)) {
				case IDM_SELECTBOARD:
					//ѡͼ,okSelect.c
					DialogBox(hInst, "SelectBox", hWnd, (FARPROC)SelectDlgProc);
					break;
				case IDM_BDISPLAY:
					//ط
					ScreenDisplay();
					break;
				case IDM_EXITOKFUN:
					//˳
					SendMessage(hWnd,WM_CLOSE,0,0);
					break;
				case IDM_ACTIVE:
					//ɼ
					switch(CaptureTarget){
					case SCREEN:
						//Ļ
					GetBitmapHeader(hBoard, SCREEN, lpbi); 
					okSetToWndRect(hBoard,hWnd); 
					//UpdateWindow(hWnd);
					okStopCapture(hBoard); //confirm
					//specail capture to frame
					if( okGetTypeCode(hBoard,NULL)==OK_C70 ) {
						okCaptureTo(hBoard,FRAME,0,0);
						EnableItem(hWnd, IDM_ACTIVE, FALSE);
						EnableItem(hWnd, IDM_FREEZE, TRUE);
					} //normal to screen
					else if( okCaptureToScreen(hBoard)<=0 )
						MessageBox(hwnd,"Current Screen (VGA) format not supported\n Or video source not connected !", "Error",MB_OK);
					else {
						EnableItem(hWnd, IDM_ACTIVE, FALSE);
						EnableItem(hWnd, IDM_FREEZE, TRUE);
						bActive=1;
					}
						break;
					case FRAME:
						//֡
						EnableItem(hWnd, IDM_FREEZE, TRUE);
						okCaptureTo(hBoard,FRAME,0,0); //cont.
						break;
					case BUFFER:
						//
						EnableItem(hWnd, IDM_FREEZE, TRUE);
						okSetSeqCallback(hBoard,BeginCapture,BackDisplay,EndCapture);
						okCaptureTo(hBoard,BUFFER,(WORD)(CaptureStart-1),(LPARAM)(CaptureEnd-CaptureStart+1));//-1: loop infiniately
						break;
					case USERMEMORY:
						//ڴ
						EnableItem(hWnd, IDM_FREEZE, TRUE);
						okSetSeqCallback(hBoard,BeginCapture,BackDisplay,EndCapture);
						if(lpbi)
							okCaptureByBuffer(hBoard,(TARGET)lpMemory,(WORD)(CaptureStart-1),(LPARAM)(CaptureEnd-CaptureStart+1));
						break;
					case USERFILE:
						//ļ
					EnableItem(hWnd, IDM_FREEZE, TRUE);
					okSetSeqCallback(hBoard,BeginCapture,BackDisplay,EndCapture);
					//first delete ok.seq
					DeleteFile(seqfile);
					okCaptureByBuffer(hBoard,(TARGET)seqfile,0,iNumImage);
					break;
					}//end select CaptureTarget
					break;
				case IDM_FREEZE:
					//
					okStopCapture(hBoard);
					ValidateRect(hWnd,NULL);
					if(bActive) 
					{	
						//take buffer size
						GetBitmapHeader(hBoard, BUFFER, lpbi); 
						SetDataToDIB(SCREEN, 0, lpbi, lpdib);
						//GetBitmapData(hBoard, SCREEN, 0, lpbi, lpdib);
						DisplayDIBInfo(hWnd);
					}
					bActive=0;
					EnableItem(hWnd, IDM_FREEZE, FALSE);
					EnableItem(hWnd, IDM_ACTIVE, TRUE);
					break;
				case IDM_SOURCE:
					//ƵԴ okSource.c
					MessageBeep(MB_ICONEXCLAMATION);		
					DialogBox(hInst, (LPCSTR)IDD_SOURCE, hWnd, (FARPROC)IddSource);
					break;
				case IDM_PARA:
					//ɼ okParam.c
					MessageBeep(MB_ICONEXCLAMATION);		
					DialogBox(hInst, (LPCSTR)IDD_VIDEOPARAM, hWnd, (FARPROC)IddVideoParam);
					break;
				case ID_MASK:
					//ɼλ,okMask.c
					MessageBeep(MB_ICONEXCLAMATION);		
					DialogBox(hInst, (LPCSTR)IDD_MASK, hWnd, (FARPROC)IddMask);
					break;
				case ID_CAPTURESETUP:
					//ɼ okSetup.c
					MessageBeep(MB_ICONEXCLAMATION);		
					DialogBox(hInst, (LPCSTR)IDD_CAPTURESETUP, hWnd, (FARPROC)IddCSetup);
					if(CaptureTarget==SCREEN || CaptureTarget==FRAME) EnableItem(hWnd,IDM_BDISPLAY,FALSE);
					else EnableItem(hWnd,IDM_BDISPLAY,TRUE);
					break;
				case IDM_OTHER:
					//  okOther.c
					MessageBeep(MB_ICONEXCLAMATION);		
					DialogBox(hInst, (LPCSTR)IDD_OTHER, hWnd, (FARPROC)IddOther);
					break;
				case ID_OUTLUT:
					//ãokOutLut.c
					MessageBeep(MB_ICONEXCLAMATION);		
					DialogBox(hInst, (LPCSTR)IDD_OUTLUT, hWnd, (FARPROC)IddOutLut);
					break;
				case ID_TO8BIT:
					//10λãokTo8Bit.c
					MessageBeep(MB_ICONEXCLAMATION);		
					DialogBox(hInst, (LPCSTR)IDD_TO8BIT, hWnd, (FARPROC)IddTo8Bit);
					break;
			}//end switch command
		default:
			return DefWindowProc(hWnd,message,wParam,lParam);
	}//end switch message
	return 0;
}

void ScreenDisplay(void)
{
	long no;
	BLOCKINFO	blk,blkTg;
	short		width,height;
	long		blkform;
	long		bufform;

	bufform=GetTargetSize(hBoard, BUFFER, &width, &height);
	if( (LOWORD(bufform)==FORM_GRAY10) || (LOWORD(bufform)==FORM_GRAY12) ) { //special  
		//blkform=okSetCaptureParam(hBoard,CAPTURE_SCRRGBFORMAT,GETCURRPARAM); //-1
		blkform=MAKELONG(FORM_GRAY8,8);
	}
	else //take same bits as buffer
		blkform=bufform;
	SetBitmapHeader(lpbi, width, height, HIWORD(blkform), LOWORD(blkform) );

	blk.lpBits=lpdib;
	blk.iBitCount=lpbi->biBitCount;
	blk.iWidth=(short)lpbi->biWidth;

	blkTg.lpBits=lpMemory;
	blkTg.iBitCount=lpbi->biBitCount;
	blkTg.iWidth=(short)lpbi->biWidth;

	if( okSetCaptureParam(hBoard,CAPTURE_SAMPLEFIELD,-1)==0 ) //sample in field by field
		if( LOWORD(okSetVideoParam(hBoard,VIDEO_SIGNALTYPE,-1))==1 ) //interlace video
			lpbi->biHeight*=2; //double size for ht

	blk.iHeight=-(short)lpbi->biHeight; //note: minus is for invert dib in y by ConvertRect	
	blkTg.iHeight=-(short)lpbi->biHeight;
	switch(CaptureTarget){
	case SCREEN:
		//Ļ
	case FRAME:
		//֡
		break;
	case BUFFER:
		//
		for(no=CaptureStart;no<=CaptureEnd;no++){
			if( (LOWORD(bufform)==FORM_GRAY10) ||(LOWORD(bufform)==FORM_GRAY12) ) { //special  
				//way 1
				okConvertRect(hBoard,(TARGET)&blk,0,BUFFER,(short)no,1);
				//way 2
				//okReadRectEx(hBoard,BUFFER,(short)no,lpdib, MAKELONG(FORM_GRAY8,1)); 
														 //read only red data
			}
			else {
				//way 1
				okTransferRect(hBoard,(TARGET)&blk,0,BUFFER,(short)no,1);
				//way 2
				//okReadRect(hBoard,BUFFER,(short)no,lpdib);
			}
			InvalidateRect(hwnd,NULL,FALSE);
			UpdateWindow(hwnd);
			//Sleep(100);
		}
		break;
	case USERMEMORY:
		//ڴ
		for(no=CaptureStart;no<=CaptureEnd;no++){
			blkTg.lpBits=lpMemory+(GetFrameSize(hBoard) * (no-1));
			if( (LOWORD(bufform)==FORM_GRAY10) ||(LOWORD(bufform)==FORM_GRAY12) ) { //special  
				//way 1
				okConvertRect(hBoard,(TARGET)&blk,0,(TARGET)&blkTg,(short)no,1);
				//way 2
				//okReadRectEx(hBoard,BUFFER,(short)no,lpdib, MAKELONG(FORM_GRAY8,1)); 
														 //read only red data
			}
			else {
				//way 1
				okTransferRect(hBoard,(TARGET)&blk,0,(TARGET)&blkTg,(short)no,1);
				//way 2
				//okReadRect(hBoard,BUFFER,(short)no,lpdib);
			}
			InvalidateRect(hwnd,NULL,FALSE);
			UpdateWindow(hwnd);
			Sleep(100);
		}
		break;
	case USERFILE:
		//ļ
		break;
	}
}

//to open one board as current board to operate
HANDLE	OpenCard(HWND hWnd)
{
	//RECT			rcVidRect;	
	//򿪲ɼ,زɼ
//	short	typecode;
	char	string[100];
	MEMORYSTATUS Status;

	//check if pre_allocated buffer
	okGetAvailBuffer(NULL,&dwBufSize);	//ѷڴ
	//okGetBufferSize(hBoard,NULL,&dwBufSize);//			
	if(dwBufSize==0) 
		MessageBox(hwnd, "There are no buffer pre-allocated !","Warning",MB_OK);

	//just starting, then allocated memory for dib
	if(!lpbi) { 
		//ΪӦóڴ
		GlobalMemoryStatus(&Status);

		//determaine how many memory will be allocated as user memory
		dwMaxMemSize=Status.dwTotalPhys-dwBufSize-32*(1<<20); //I'd keep 32M for window system
		if(dwMaxMemSize<=0)
			dwMaxMemSize=5*(1<<20); //5M
		else if( dwMaxMemSize>Status.dwAvailPhys )
			dwMaxMemSize=Status.dwAvailPhys/2;

		if( dwMaxMemSize<5*(1<<20) ) //need 5M at least for user memory
			dwMaxMemSize=max(5*(1<<20),Status.dwAvailPhys);


		lpbi=(LPBITMAPINFOHEADER)GlobalAlloc(GPTR,dwMaxMemSize);
		if(lpbi==NULL) {
			dwMaxMemSize=4*(1<<20); //4M
			lpbi=GlobalAlloc(GPTR,dwMaxMemSize);
		}
		lpdib=(LPSTR)lpbi+5120; //keep 5k for bi
		lpMemory=(LPSTR)lpbi+2048*1024; //keep 2M for dib
		dwMaxMemSize-=2048*1024+5120;

		if(lpbi) {
			sprintf(string,"Allocated memory = %d",dwMaxMemSize);
		}else
			sprintf(string,"Allocate memory failed !");
	//	MessageBox(hwnd,string,"Message",MB_OK);

	}

	//open one specified board
	if( !(hBoard=okOpenBoard(&iCurrUsedNo)) ) {//set 
	//if( !(hBoard=okOpenImageBoard(-1)) ) //select default 
		long	error;
		error=okGetLastError();
		if(error==ERR_NOTFOUNDBOARD)
			MessageBox(hwnd, "Not found Ok series Image Board !","Warning",MB_OK);
		else if (error==ERR_NOTFOUNDVXDDRV)
			MessageBox(hwnd, "Not found VxD driver for Ok series Image Board !","Warning",MB_OK);
		else
			MessageBox(hwnd, "Open selected board failed!","Warning",MB_OK);

		return FALSE;
	}

	GetBitmapHeader(hBoard, SCREEN, lpbi); 
	//set initial size
	sampwidth=(short)lpbi->biWidth;
	sampheight=(short)lpbi->biHeight;
	//initailize screen
	okSetToWndRect(hBoard,hWnd);
	EnableItem(hWnd, IDM_FREEZE, FALSE);
	EnableItem(hWnd, IDM_BDISPLAY, FALSE);

	InvalidateRect(hWnd,NULL,FALSE);

	return hBoard;
}


BOOL GetBitmapHeader(HANDLE hBoard, TARGET src, LPBITMAPINFOHEADER lpbi)
{
	short		width,height;
	long		form;

	form=GetTargetSize(hBoard, src, &width, &height);

	//here take form as screen forever 
	form=okSetCaptureParam(hBoard,CAPTURE_SCRRGBFORMAT,GETCURRPARAM); //-1

	SetBitmapHeader(lpbi, width, height, HIWORD(form), LOWORD(form) );

	return LOWORD(form);
}

//set bitmap header and bitmap info if need
long SetBitmapHeader(LPBITMAPINFOHEADER lpbi,short width,short height, short bits, short form)
{
	long	wbytes;

	if(!lpbi)
		return FALSE;

	lpbi->biWidth=width;
	lpbi->biHeight=height;

	lpbi->biSize=sizeof(BITMAPINFOHEADER);
	lpbi->biPlanes=1;

	lpbi->biBitCount=bits;
	wbytes=((((lpbi->biWidth*bits)+31)&~31)>>3);//bmp need 4 align
	lpbi->biSizeImage=wbytes*lpbi->biHeight;

	lpbi->biClrUsed=0;
	//special format for 555,565 & 32 
	if(form==FORM_RGB555 || form==FORM_RGB565 || form==FORM_RGB8888 ) 
		lpbi->biCompression=BI_BITFIELDS;
	else
		lpbi->biCompression=0;
	if(lpbi->biCompression==BI_BITFIELDS) {//
		DWORD	*lpmask;
		lpmask=(DWORD *)((LPSTR)lpbi+lpbi->biSize);

		if(form==FORM_RGB555) {
			lpmask[2]=0x001f; //blue
			lpmask[1]=0x03e0;
			lpmask[0]=0x7c00;
		}
		else if(form==FORM_RGB565) {
			lpmask[2]=0x001f; //blue
			lpmask[1]=0x07e0;
			lpmask[0]=0xf800;
		}
		else if(bits==32) {
			lpmask[2]=0x0000ff;
			lpmask[1]=0x00ff00;
			lpmask[0]=0xff0000;
		}
	}
	else if(bits<=12) { // 8,10,12
		int		i;
		RGBQUAD	*lpRGB=(RGBQUAD *)((LPSTR)lpbi+lpbi->biSize);

		lpbi->biClrUsed=(1<<bits);
		for(i=0; i<(short)lpbi->biClrUsed;i++) {
			lpRGB[i].rgbBlue=i;
			lpRGB[i].rgbGreen=i;
			lpRGB[i].rgbRed=i;
			lpRGB[i].rgbReserved=0;
		}
	} 
	lpbi->biClrImportant=lpbi->biClrUsed;

	return lpbi->biClrUsed;
}

//get size 
long GetTargetSize(HANDLE hBoard, TARGET tgt, short *width, short *height)
{
	RECT	rect;
	long	form;


	if( (tgt==SCREEN ) ||(tgt==BUFFER) ) {
		rect.right=-1;
		okSetTargetRect(hBoard,tgt,&rect); //get current rect
		*width=(short)(rect.right-rect.left);
		*height=(short)(rect.bottom-rect.top);

		if(tgt==SCREEN ) {
			form=okSetCaptureParam(hBoard,CAPTURE_SCRRGBFORMAT,GETCURRPARAM); //-1
			//limit to video rect
			rect.right=-1; //max. captured rect
			okSetTargetRect(hBoard,VIDEO,&rect); //get video rect
			*width=(short)min(*width,rect.right-rect.left);
			*height=(short)min(*height,rect.bottom-rect.top);
		}
		else if(tgt==BUFFER) 
			form=okSetCaptureParam(hBoard,CAPTURE_BUFRGBFORMAT,GETCURRPARAM); //-1

	} else if(tgt>BUFFER) { //from blkinfo
		LPBLOCKINFO	lpblk;
		lpblk=(LPBLOCKINFO)tgt;

		*width=lpblk->iWidth;
		*height=abs(lpblk->iHeight);
		form=MAKELONG(lpblk->iFormType,lpblk->iBitCount);
	}


	return form;
}

//switch menu freeze/active
void EnableItem(HWND hWnd, int iMenuID, BOOL bEnable)
{
	HMENU	hMenu;

	hMenu=GetMenu(hWnd);
	//ModifyMenu(hMenu,IDM_FREEZE,MF_BYCOMMAND|MF_STRING,IDM_ACTIVE,"&Active");
	if(bEnable) 
		EnableMenuItem(hMenu,iMenuID,MF_BYCOMMAND|MF_ENABLED);
	else
		EnableMenuItem(hMenu,iMenuID,MF_BYCOMMAND|MF_GRAYED);

	DrawMenuBar(hWnd);

}

//display current dib info
void DisplayDIBInfo(HWND hwnd)
{

	char	string[200];
	LPSTR	lpstr;	

	GetWindowText(hwnd,string,120);
	lpstr=strchr(string,'-');
	if(!lpstr)
		lpstr=string+strlen(string);
	sprintf(lpstr,"- %d x %d x %d",lpbi->biWidth,lpbi->biHeight,lpbi->biBitCount);
	if(lpbi->biWidth)
		SetWindowText(hwnd,string);

}

//set data to dib 
long SetDataToDIB(TARGET src, short start, LPBITMAPINFOHEADER lpbi, LPBYTE lpdib)
{
	BLOCKINFO	blk;

	//get image to app buffer from tgt
	blk.lpBits=lpdib;			
	blk.iWidth=(short)lpbi->biWidth;
	blk.iHeight=-(short)lpbi->biHeight; //to invert y
	blk.iBitCount=lpbi->biBitCount;
	if(lpbi->biCompression==BI_BITFIELDS) {//
		DWORD	*lpMask;
		lpMask=(DWORD *)((LPSTR)lpbi+lpbi->biSize);
		if(lpMask[1]==0x03e0) //555
			blk.iFormType=FORM_RGB555;
	}

	return okConvertRect(hBoard,(TARGET)&blk,0,src,start,1);
}

//---you must set gray logic palette when VGA is 256 color mode
void SetPaletteToWnd(HDC hDC)
{
	static	HPALETTE	hPalette;
	long	form;
	short	bits;

	//get current screen(VGA) format 
	form=okSetCaptureParam(hBoard,CAPTURE_SCRRGBFORMAT,GETCURRPARAM); //-1
	bits=HIWORD(form); //take HIWORD
	form=LOWORD(form);

	if(bits==8 || bits==10) { //gray
		if(!hPalette)  
			hPalette=MakeLogPalette(bits,(short)form);

		SelectPalette(hDC,hPalette,0);
		RealizePalette(hDC);     // GDI Bug
	}
}

//----demo to make a gray logic palette
HPALETTE MakeLogPalette(short iBits, short rgbForm)
{
    HPALETTE    hLogPal; 
    NPLOGPALETTE npPal;
    WORD        nNumColors;
    short		i;

	nNumColors=(WORD)(1<<iBits);
	npPal = (NPLOGPALETTE)LocalAlloc(LMEM_FIXED, sizeof(LOGPALETTE) + 
				    nNumColors * sizeof(PALETTEENTRY));
    if (!npPal)
		return(FALSE);
	
	npPal->palVersion = 0x300;
    npPal->palNumEntries = nNumColors;
	//set palette
	if(rgbForm==FORM_RGB332) { //rgb 332
		BYTE	red=0, green=0, blue=0;
			
		for (i = 0; i < nNumColors; i++ ) {
			npPal->palPalEntry[i].peBlue = blue;
			npPal->palPalEntry[i].peGreen = green;
			npPal->palPalEntry[i].peRed = red;
			npPal->palPalEntry[i].peFlags = 0;
			if (!(red += 32))
				if (!(green += 32))
			    	blue += 64;			
		}
	}
	else { //gray 256 or 1024
		for (i = 0; i < nNumColors; i++ ) {
			npPal->palPalEntry[i].peRed = (BYTE)i;
			npPal->palPalEntry[i].peGreen = (BYTE)i;
			npPal->palPalEntry[i].peBlue = (BYTE)i;
			npPal->palPalEntry[i].peFlags = 0;
		}
	}

	hLogPal = CreatePalette((LPLOGPALETTE)npPal);
	LocalFree((HANDLE)npPal);

	return(hLogPal);
}



//------------callback runtines----------
long		elapsed;
long		numframe;
char		string[256];
long		bufform;
BLOCKINFO	blk;

BOOL CALLBACK BeginCapture(HANDLE hBoard)
{
	short		width,height;
	long		blkform;

	if(bDispToScreen) {
		bufform=GetTargetSize(hBoard, BUFFER, &width, &height);
		if( (LOWORD(bufform)==FORM_GRAY10) || (LOWORD(bufform)==FORM_GRAY12) ) { //special  
			//blkform=okSetCaptureParam(hBoard,CAPTURE_SCRRGBFORMAT,GETCURRPARAM); //-1
			blkform=MAKELONG(FORM_GRAY8,8);
		}
		else //take same bits as buffer
			blkform=bufform;
		SetBitmapHeader(lpbi, width, height, HIWORD(blkform), LOWORD(blkform) );
	}

	blk.lpBits=lpdib;
	blk.iBitCount=lpbi->biBitCount;
	blk.iWidth=(short)lpbi->biWidth;

	if( okSetCaptureParam(hBoard,CAPTURE_SAMPLEFIELD,-1)==0 ) //sample in field by field
		if( LOWORD(okSetVideoParam(hBoard,VIDEO_SIGNALTYPE,-1))==1 ) //interlace video
			lpbi->biHeight*=2; //double size for ht

	blk.iHeight=-(short)lpbi->biHeight; //note: minus is for invert dib in y by ConvertRect	

	elapsed=GetTickCount();
	numframe=0;

	return 1;
}


BOOL CALLBACK BackDisplay(HANDLE hBoard,long no)
{		
	//return 1;

	numframe++;
	//sprintf(string,"captured frames = %d ",no);
	sprintf(string,"Total frames = %d; Current = %d ",numframe, no);
	SetWindowText(hwnd,string);

	if(bDispToScreen) {
		if( (LOWORD(bufform)==FORM_GRAY10) ||(LOWORD(bufform)==FORM_GRAY12) ) { //special  
			//way 1
			okConvertRect(hBoard,(TARGET)&blk,0,BUFFER,(short)no,1);
			//way 2
			//okReadRectEx(hBoard,BUFFER,(short)no,lpdib, MAKELONG(FORM_GRAY8,1)); 
														 //read only red data
		}
		else {
			//way 1
			okTransferRect(hBoard,(TARGET)&blk,0,BUFFER,(short)no,1);
			//way 2
			//okReadRect(hBoard,BUFFER,(short)no,lpdib);
		}
		InvalidateRect(hwnd,NULL,FALSE);
	}

	return 1;
}


BOOL CALLBACK SetToScreen(HANDLE hBoard,long no)
{		
	//numframe++;
	//sprintf(string,"captured frames = %d ",no);
	//SetWindowText(hwnd,string);

	if( (LOWORD(bufform)==FORM_GRAY10) || (LOWORD(bufform)==FORM_GRAY12) ) { //special  
		//way 1
		okConvertRect(hBoard,(TARGET)&blk,0,BUFFER,(short)no,1);

		//way 2
		//okReadRectEx(hBoard,BUFFER,(short)no,lpdib);
		//ConvertBitmap(lpbi,lpdib);
	}
	else {
		okTransferRect(hBoard,(TARGET)&blk,0,BUFFER,(short)no,1);	
		//way 2
		//okReadRect(hBoard,BUFFER,(short)no,lpdib);
		//ConvertBitmap(lpbi,lpdib);
	}

	InvalidateRect(hwnd,NULL,FALSE);
	UpdateWindow(hwnd);

	return 1;
}

BOOL CALLBACK EndCapture(HANDLE hBoard)
{
	
	elapsed=GetTickCount()-elapsed;								

	sprintf(string,"Total frames = %d;  elapsed time= %d ms",numframe,elapsed);
	SetWindowText(hwnd,string);

	//clear callback
	okSetSeqCallback(hBoard,NULL,NULL,NULL);

	return 1;
}

long GetFrameSize(HANDLE hBoard)
{
	long	bits,size;

	size=okSetCaptureParam(hBoard,CAPTURE_BUFBLOCKSIZE,-1);
	bits=okSetCaptureParam(hBoard,CAPTURE_BUFRGBFORMAT,-1);
	size=(HIWORD(bits))/8*LOWORD(size)*HIWORD(size);

	return size;
}

void SingleCapture(void)
{
	okCaptureTo(hBoard,BUFFER,0,1);//single
	okGetCaptureStatus(hBoard,1);
	Sleep(20); //do waiting here
	//buf->scr
	GetBitmapHeader(hBoard, BUFFER, lpbi); 
	SetDataToDIB(BUFFER, 0, lpbi, lpdib);
	//okStopCapture(hBoard);
	InvalidateRect(hwnd,NULL,TRUE);
}
