#include <windows.h>
#include <commdlg.h>

#include <stdio.h>

#include "resource.h"

#include "okapi32.h"

extern	HANDLE		hBoard;

void DemoMask();

BOOL APIENTRY IddMask(HWND hDlg,unsigned message,UINT wParam,LONG lParam)
{
	//ɼλ
    switch (message){
	case WM_INITDIALOG:
		switch(okEnableMask(hBoard,-1)){
		case 0:
			break;
		case 1:
			CheckDlgButton(hDlg,IDC_SETMASK,TRUE);
			CheckDlgButton(hDlg,IDC_SHARPMASK,TRUE);
			break;
		case 2:
			CheckDlgButton(hDlg,IDC_SETMASK,TRUE);
			break;
		}
		break;
	case WM_COMMAND:
		switch(LOWORD(wParam)){
		case IDOK:
			//λ
			okEnableMask(hBoard,0);
			if(IsDlgButtonChecked(hDlg,IDC_SETMASK)){
				DemoMask();

				//λ
				if(IsDlgButtonChecked(hDlg,IDC_SHARPMASK)) okEnableMask(hBoard,1);
				else okEnableMask(hBoard,2);
			}

			EndDialog(hDlg,TRUE);
			return (TRUE);
		case IDCANCEL:
            EndDialog(hDlg, TRUE);
            return (TRUE);
		default:
			break;
		}
        break;
	default:
		break;
	}
	return (FALSE);
}

void EnabledDlgItem(HWND hDlg,BOOL Param)
{
	EnableWindow(GetDlgItem(hDlg,IDC_RADIOLOW),Param);
	EnableWindow(GetDlgItem(hDlg,IDC_RADIOMID),Param);
	EnableWindow(GetDlgItem(hDlg,IDC_RADIOHIGH),Param);
	EnableWindow(GetDlgItem(hDlg,IDC_SCROLLBARHORI),Param);
	EnableWindow(GetDlgItem(hDlg,IDC_SCROLLBARVERT),Param);
}


//--demo to mask some areas just for those cards with masking capablilty   
void DemoMask()
{
	int		i;
	RECT	rect;
	BYTE	lpMask[40960];
	
	//1. way to set mask rect
	ZeroMemory(lpMask,20000); //clear bits 
	SetRect(&rect,10,10,110,110);	
	for(i=20;i<80;i++)
		lpMask[100+i]=1;
	for(i=1;i<99;i++)
		lpMask[5000+i]=1;

	for(i=1;i<99;i++)
		lpMask[100*50+i]=1;
	for(i=1;i<99;i++)
		lpMask[i*100+50]=1;
	okSetMaskRect(hBoard,&rect,lpMask);

	FillMemory(lpMask,40000,1); //set bits 
	SetRect(&rect,200,19,300,119);	
	for(i=1;i<99;i++)
		lpMask[5000+i]=0;
	for(i=1;i<99;i++)
		lpMask[i*100+50]=0;
	okSetMaskRect(hBoard,&rect,lpMask);

	//2. way
	rect.left=200;
	rect.top=200;
	rect.right=280;
	rect.bottom=280;
	okSetMaskRect(hBoard,&rect,(LPSTR)0); //disable video 
	InflateRect(&rect,-20,-20);	
	okSetMaskRect(hBoard,&rect,(LPSTR)1); //enable video 

	SetRect(&rect,0,300,200,301);
	okSetMaskRect(hBoard,&rect,(LPSTR)0);  
	SetRect(&rect,0,302,200,303);
	okSetMaskRect(hBoard,&rect,(LPSTR)0);  
	SetRect(&rect,0,305,200,306);
	okSetMaskRect(hBoard,&rect,(LPSTR)0);  
}
