#include <windows.h>
#include <commdlg.h>

#include "resource.h"

#include "okapi32.h"

extern	HANDLE		hBoard;

BOOL FillOutLUT(HANDLE hBoard, short index);

BOOL APIENTRY IddOutLut(HWND hDlg,unsigned message,UINT wParam,LONG lParam)
{
	static short iPeriod;
	char tstr[80];
	char tg[4][10]={"625","1249","525","1049"};
	HWND shWnd;
	int i;

	//Էʽ
	switch(message){
	case WM_INITDIALOG:
		CheckDlgButton(hDlg,IDC_FORWARD,TRUE);
		shWnd=GetDlgItem(hDlg,IDC_FRAMELINES);
		for(i=0;i<4;i++)
			SendMessage(shWnd,CB_INSERTSTRING,0,(LPARAM)(LPCSTR)tg[3-i]);

		SendMessage(shWnd,CB_SETCURSEL,0,0);

		iPeriod=(short)okSetVideoParam(hBoard,VIDEO_LINEPERIOD,-1);
		SetScrollRange(GetDlgItem(hDlg,IDC_SCROLLBAR1),SB_CTL,0,127,FALSE);
		SetScrollPos(GetDlgItem(hDlg,IDC_SCROLLBAR1),SB_CTL,iPeriod,TRUE);
		wsprintf(tstr,"%d",iPeriod);
		SetDlgItemText(hDlg,IDC_LINEPERIOD,tstr);
		break;
	case WM_HSCROLL:
		switch(LOWORD(wParam)){
        case SB_PAGEDOWN:
			iPeriod+=3;
			if(iPeriod>127) iPeriod=127;
			break;
        case SB_LINEDOWN:
			iPeriod++;
			if(iPeriod>127) iPeriod=127;
			break;
        case SB_PAGEUP:
			iPeriod-=3;
			if(iPeriod<0) iPeriod=0;
			break;
        case SB_LINEUP:
			iPeriod--;
			if(iPeriod<0) iPeriod=0;
			break;
        case SB_TOP :
			iPeriod=0;
			break;
        case SB_BOTTOM:
			iPeriod=127;
			break;
        case SB_THUMBPOSITION:
        case SB_THUMBTRACK:
			iPeriod=HIWORD(wParam);
			break;
		}
		SetScrollPos(GetDlgItem(hDlg,IDC_SCROLLBAR1),SB_CTL,iPeriod,TRUE);
		wsprintf(tstr,"%d",iPeriod);
		SetDlgItemText(hDlg,IDC_LINEPERIOD,tstr);
		break;
	case WM_COMMAND:
		switch(LOWORD(wParam)){
		case IDOK:
			//ұ
			if(IsDlgButtonChecked(hDlg,IDC_FORWARD)) FillOutLUT(hBoard,0);
			else FillOutLUT(hBoard,1);

			//
			okSetVideoParam(hBoard,VIDEO_LINEPERIOD,iPeriod);

			//֡
			i=SendMessage(GetDlgItem(hDlg,IDC_FRAMELINES),CB_GETCURSEL,0,0);
			okSetVideoParam(hBoard,VIDEO_FRAMELINES,i);
            EndDialog(hDlg, TRUE);
            return (TRUE);
		case IDCANCEL:
            EndDialog(hDlg, TRUE);
            return (TRUE);
		}
		break;
	}
	return FALSE;
}

//--demo to fill outlut to these cards with out LUT
BOOL FillOutLUT(HANDLE hBoard, short index)
{
	BYTE	bLUT[768][3];
	short	i,start=0,num=180,gray=256;

	switch (index) {
		case 0:
			for(i=0;i<gray;i++) {
				bLUT[i][0]=(BYTE)i;
				bLUT[i][1]=(BYTE)i;
				bLUT[i][2]=(BYTE)i;
			}
			okFillOutLUT(hBoard, (LPBYTE)bLUT, start, gray);	
			break;
		case 1:
			for(i=0;i<num;i++) {
				bLUT[i][0]=(BYTE)(num-i);
				bLUT[i][1]=(BYTE)(num-i);
				bLUT[i][2]=(BYTE)(num-i);
			}
			for(i=num;i<gray;i++) {
				bLUT[i][0]=0;
				bLUT[i][1]=0;
				bLUT[i][2]=0;
			}
			okFillOutLUT(hBoard, (LPBYTE)bLUT, start, gray);	
			break;
		default:
			break;
	}

	return 1;
}
