#include <windows.h>
#include <commdlg.h>

#include <stdio.h>

#include "resource.h"

#include "okapi32.h"

extern	HANDLE		hBoard;
extern	long		iCurrUsedNo;
extern	HWND		hwnd;
extern	BYTE		bActive;

extern	HANDLE	OpenCard(HWND hWnd);

//demo to select one baord in the current list slotted in PC
BOOL APIENTRY SelectDlgProc(HWND hDlg,unsigned message,WORD wParam,LONG lParam)
{
    switch (message)
    {
		int			i,total;
		BOARDTYPE	*lpBoardInfo;
		static		iVirtCode=0;
		static		char szVirtName[30];
		char		string[120];

        case WM_INITDIALOG:
			total=okGetSlotBoard(&lpBoardInfo);
			if( !iVirtCode && (iCurrUsedNo>=total) ) { //one virtual card 
				iVirtCode=okGetTypeCode(hBoard, szVirtName);
			}

            SetDlgItemInt(hDlg,IDC_TOTALBOARD,total,FALSE);
			for(i=0;i<total;i++) {
				sprintf(string," No.%d :  Type code=%d,  Name=%s ",
					i,lpBoardInfo[i].iBoardTypeCode,lpBoardInfo[i].szBoardName);
				SendDlgItemMessage(hDlg,IDC_BOARDLIST,CB_ADDSTRING,0,(LPARAM)string); 
			}
			if(iVirtCode) {
				sprintf(string," Virtual:  Type code=%d,  Name=%s ",iVirtCode,szVirtName);
				SendDlgItemMessage(hDlg,IDC_BOARDLIST,CB_ADDSTRING,0,(LPARAM)string); 
			}
			if(iCurrUsedNo<0)
				iCurrUsedNo=0;
			SendDlgItemMessage(hDlg,IDC_BOARDLIST,CB_SETCURSEL,iCurrUsedNo,0);
			SetDlgItemInt(hDlg,IDC_CURRUSED,iCurrUsedNo,0);

			return (TRUE);

        case WM_COMMAND:
            if (wParam == IDOK )
            {
				HANDLE	hOld=hBoard;

				okCloseBoard(hOld);
				hBoard=OpenCard(hwnd);

				bActive=0;

			}
			if (wParam == IDOK || wParam == IDCANCEL) {
                EndDialog(hDlg, TRUE);
                return (TRUE);
            }
            
			else if (wParam == IDC_BOARDLIST) {
				iCurrUsedNo=SendDlgItemMessage(hDlg,IDC_BOARDLIST,CB_GETCURSEL,0,0);
				if(iCurrUsedNo==-1)
					iCurrUsedNo=0;
				SetDlgItemInt(hDlg,IDC_CURRUSED,iCurrUsedNo,0);

			}
            break;
    }
    return (FALSE);
}
