#include <windows.h>
#include <commdlg.h>

#include "resource.h"

#include "okapi32.h"

extern	HANDLE		hBoard;

BOOL APIENTRY IddTo8Bit(HWND hDlg,unsigned message,UINT wParam,LONG lParam)
{
	static WORD wCur;
	WORD wh;
	long dwr;
	char tstr[80];

    switch (message)
    {
	case WM_INITDIALOG:
		SetScrollRange(GetDlgItem(hDlg,IDC_SCROLLBAR1),SB_CTL,0,1023,FALSE);

		dwr=okSetCaptureParam(hBoard,CAPTURE_TO8BITMODE,-1);
		wCur=LOWORD(dwr);
		SetScrollPos(GetDlgItem(hDlg,IDC_SCROLLBAR1),SB_CTL,wCur,TRUE);
		wsprintf(tstr,"%d",wCur);
		SetDlgItemText(hDlg,IDC_TO8BIT,tstr);
		if(HIWORD(dwr)){
			CheckDlgButton(hDlg,IDC_RADIO2,TRUE);
			EnableWindow(GetDlgItem(hDlg,IDC_SCROLLBAR1),TRUE);
		}
		else{
			CheckDlgButton(hDlg,IDC_RADIO1,TRUE);
			EnableWindow(GetDlgItem(hDlg,IDC_SCROLLBAR1),FALSE);
		}
		break;
	case WM_HSCROLL:
		switch(LOWORD(wParam)){
        case SB_PAGEDOWN:
			wCur+=3;
			if(wCur>1023) wCur=1023;
			break;
        case SB_LINEDOWN:
			wCur++;
			if(wCur>1023) wCur=1023;
			break;
        case SB_PAGEUP:
			wCur-=3;
			if(wCur<0) wCur=0;
			break;
        case SB_LINEUP:
			wCur--;
			if(wCur<0) wCur=0;
			break;
        case SB_TOP :
			wCur=0;
			break;
        case SB_BOTTOM:
			wCur=1023;
			break;
        case SB_THUMBPOSITION:
        case SB_THUMBTRACK:
			wCur=HIWORD(wParam);
			break;
		}
		SetScrollPos(GetDlgItem(hDlg,IDC_SCROLLBAR1),SB_CTL,wCur,TRUE);
		wsprintf(tstr,"%d",wCur);
		SetDlgItemText(hDlg,IDC_TO8BIT,tstr);
		break;
	case WM_COMMAND:
		switch(LOWORD(wParam)){
		case IDC_RADIO1:
			EnableWindow(GetDlgItem(hDlg,IDC_SCROLLBAR1),FALSE);
			break;
		case IDC_RADIO2:
			EnableWindow(GetDlgItem(hDlg,IDC_SCROLLBAR1),TRUE);
			break;
		case IDOK:
			//10λ任ģʽ
			if(IsDlgButtonChecked(hDlg,IDC_RADIO1)) wh=0;
			else wh=1;
			dwr=okSetCaptureParam(hBoard,CAPTURE_TO8BITMODE,MAKELONG(wCur,wh));
			EndDialog(hDlg,TRUE);
			return TRUE;
		case IDCANCEL:
            EndDialog(hDlg, TRUE);
            return TRUE;
		default:
			break;
		}
        break;
	default:
		break;
	}
	return FALSE;
}
