
//---------------okapi32.h---------------------------------
//
// ok api32 header file for user
//
//---------------------------------------------------------

//----contant defines----

//--defines of ok series image board identity
//Mono series
#define		OK_M10					1010
#define		OK_M10N					1010
#define		OK_M10M					1013
#define		OK_M10F					1011
#define		OK_M10L					1014
#define		OK_M10H					1012
#define		OK_M20					1020
#define		OK_M20C					1021

#define		OK_M20H					1022
#define		OK_M30					1030
#define		OK_M40					1040
#define		OK_M50					1050
#define		OK_M60					1060
#define		OK_M70					1070
#define		OK_M80					1080
#define		OK_M80K					1081

#define		OK_M10K					1002

//Color series
#define		OK_C20					2020
#define		OK_C20C					2021
#define		OK_C30					2030
#define		OK_C30S					2031
#define		OK_C40					2040
#define		OK_C40P					2041
#define		OK_C50					2050
#define		OK_C70					2070
#define		OK_C80					2080
#define		OK_C80M					2081

#define		OK_RGB10				3010
#define		OK_RGB20				3020
#define		OK_RGB30				3030



//--error code

#define		ERR_NOERROR				0	//no error 
#define		ERR_NOTFOUNDBOARD		1	//not found available ok board 

#define		ERR_NOTFOUNDVXDDRV		2	//not found ok vxd driver
#define		ERR_NOTALLOCATEDBUF		3	//not pre-allocated buffer from host memory
#define		ERR_BUFFERNOTENOUGH		4	//available buffer not enough requirment
#define		ERR_BEYONDFRAMEBUF		5	//capture iamge size beyond buffer

#define		ERR_NOTFOUNDDRIVER		6	//no driver found
#define		ERR_NOTCORRECTDRIVER	7	//driver not correct

#define		ERR_MEMORYNOTENOUGH		8	//memory not enough
#define		ERR_FUNNOTSUPPORT		9	//the function not support
#define		ERR_OPERATEFAILED		10	//something wrong with the operation

#define		ERR_HANDLEAPIERROR		11	//the handle to okapi function wrong
#define		ERR_DRVINITWRONG		12	//something wrong with driver initialize

#define		ERR_RECTVALUEWRONG		13	//the rect set wrong
#define		ERR_FORMNOTSUPPORT		14	//the form set not support by the board

#define		ERR_TARGETNOTSUPPORT	15	//the target not support by this function

//--format defines
#define		FORM_RGB888				1	
#define		FORM_RGB565				2
#define		FORM_RGB555				3
#define		FORM_RGB8888			4
#define		FORM_RGB332				5	

#define		FORM_YUV422				6	
#define		FORM_YUV411				7	
#define		FORM_YUV16				8	
#define		FORM_YUV12				9	
#define		FORM_YUV9				10	
#define		FORM_YUV8				11	

#define		FORM_GRAY888			12
#define		FORM_GRAY8888			13
#define		FORM_GRAY8				14
#define		FORM_GRAY10				15
#define		FORM_GRAY12				16
#define		FORM_GRAY16				17



//--mask command
#define		MASK_DISABALE			0	//turn of mask
#define		MASK_POSITIVE			1	//0 win clients visible, 1 video visible
#define		MASK_NEGATIVE			2	//0 for video 1 for win client (graph)


//--tv system standard
#define		TV_PALSTANDARD			0	//PAL
#define		TV_NTSCSTANDARD			1	//NTSC
#define		TV_NONSTANDARD			2	//NON_STD


#define		TV_PALMAXWIDTH			768
#define		TV_PALMAXHEIGHT			576

#define		TV_NTSCMAXWIDTH			640 //720
#define		TV_NTSCMAXHEIGHT		480


//-----defines lParam for get param
#define		GETCURRPARAM			-1 

//-----sub-function defines for wParam of SetVideoParam
		//wParam cab be one of the follow
#define		VIDEO_RESETALL			0 //reset all to sys default
#define		VIDEO_SOURCECHAN		1 
			// lParam=0,1.. Comp.Video; 0x100,101...to Y/C(S-Video), 0x200,0x201 to RGB Chan.Input
#define		VIDEO_BRIGHTNESS		2 //LOWORD is brightness, for RGB HIWORD is channel (0:red, 1:green, 2:blue)
#define		VIDEO_CONTRAST			3 //LOWORD is contrast, for RGB HIWORD is channel (0:red, 1:green, 2:blue)
#define		VIDEO_COLORHUE			4
#define		VIDEO_SATURATION		5
#define		VIDEO_RGBFORMAT			6	//when return low word  is code high word is bitcount
#define		VIDEO_TVSTANDARD		7	//0 PAL, 1 NTSC, 2 Non-stadard
#define		VIDEO_SIGNALTYPE		8	//LOWORD 0 non-interlaced, 1 interlaced
										//HIWORD 0 no slot in field header, 1 yes
#define		VIDEO_RECTSHIFT			9	//video rect shift,  makelong (x,y)
#define		VIDEO_SYNCSIGCHAN		10  //LOWORD 0:Red,1:Grn,2:Blue, 3:Sync,4 H.V.Sync; 
										//HIWORD is source 0,1,..for RGB input,  
										// 0x100,0x101,... for comp.video input 
										// (in this case LOWORD has no mean more)
#define		VIDEO_SIGREFVOLTAGE		11
#define		VIDEO_AVAILRECTSIZE		12	//makelong(horz,vert)
				//horz available pixels per scan line and
				//vert available lines per frame
#define		VIDEO_FREQSEG			13	// set horz video frequency range
										//0:Low(7.5~15MHz),  1:middle(15~30), 2:High(30~60)
#define		VIDEO_LINEPERIOD		14 //line period (in 0.5 us) generated by board
#define		VIDEO_FRAMELINES		15 //lines per frame  generated by board

#define		VIDEO_MISCCONTROL		16 //miscellaneous control bits

	
	
//-----sub-function defines for wParam of SetCaptureParam
		//wParam cab be one of the follow
#define		CAPTURE_RESETALL		0 //reset all to sys default
#define		CAPTURE_INTERVAL		1
#define		CAPTURE_CLIPMODE		2 //LOWORD: clip mode when video and dest rect not same size
									  //HIWORD: if captrure odd and even field crosslly
#define		CAPTURE_SCRRGBFORMAT	3 //when return, loword=code, hiword=bits 
#define		CAPTURE_BUFRGBFORMAT	4 
#define		CAPTURE_FRMRGBFORMAT	5
#define		CAPTURE_BUFBLOCKSIZE	6 //lParam=MAKELONG(width,height)
									  //if set it 0 (default), the rect set by user will be as block size 
#define		CAPTURE_HARDMIRROR		7   //bit0 x, bit1 y; 
#define		CAPTURE_SAMPVIALUT		8	//set sample via lut
#define		CAPTURE_VIAKFILTER		9 //sample via recursion filter
#define		CAPTURE_SAMPLEFIELD		10 //0 in field (non-interlaced), 1 in frame (interlaced), (0,1 are basic)
										//2 in field but keep expend row,3 in field but interlaced one frame
										//(2,4 can affect only sampllng field(frame) by field(frame) )
										//in 3 up-dn frame
#define		CAPTURE_HORZPIXELS		11	// set max horz pixel per scan line
#define		CAPTURE_VERTLINES		12	// set max vert lines per frame

#define		CAPTURE_ARITHMODE		13 //arithmatic mode
#define		CAPTURE_TO8BITMODE		14 //the mode of high (eg. 10 bits) converted to 8bit 
										//HIWORD(lParam)=0: linear scale, 
										//HIWORD(lParam)!=0:clip mode, LOWORD(lParam)=offset
#define		CAPTURE_SEQCAPWAIT		15	// bit0 if waiting finished for functions of sequence capturing and playbacking
										//bit1 if waiting finished capture then call callback function 

#define		CAPTURE_MISCCONTROL		16 //miscellaneous control bits



#define		SAMPLE_INFIELD			0 //in field (non-interlaced)
#define		SAMPLE_INFRAME			1 //in frame of interlaced fields
					//the above two (0,1) are basic
#define		SAMPLE_FIELDEXP			2 //in field but expend (keep expend row)
#define		SAMPLE_UPDNFRAME		3 //in frame of up-downed fields 
#define		SAMPLE_FIELDINTER		4 //in field but interlaced to one frame


//-----defines lParam for CAPTURE_CLIPMODE
#define		RECT_SCALERECT			0 
#define		RECT_CLIPCENTER			1 
#define		RECT_FIXLEFTTOP			2 
		//in condition video rect great than screen rect:
		//if RECT_SCALERECT video rect will be scaled to match screen rect if it can. else
		//video rect will be adjusted to match screen rect
		//(1: center, take center video rect  2: left-top fixed, take same size rect)


//-----sub-function defines for lParam of GetSignalParam
#define		SIGNAL_VIDEOEXIST		1 //0 video  absent, 1 exist
#define		SIGNAL_VIDEOTYPE		2 //0 field, 1 interlaced
#define		SIGNAL_SCANLINES		3 //scan lines per frame
#define		SIGNAL_LINEFREQ			4 //line frequency
#define		SIGNAL_FIELDFREQ		5 //frame frequency
#define		SIGNAL_FRAMEFREQ		6 //frame frequency
#define		SIGNAL_EXTTRIGGER		7 //extern trigger status, 1 trigger
#define		SIGNAL_FIELDID			8 //Field ID 0 odd, 1 even


//-----sub-function defines for lEvent of WaitSignalEvent
#define		EVENT_FIELDHEADER		1 //field header
#define		EVENT_FRAMEHEADER		2 //frame header
#define		EVENT_ODDFIELD			3 //odd field come
#define		EVENT_EVENFIELD			4 //even field come
#define		EVENT_EXTTRIGGER		5 //extern trigger come, 
									  //(HIWORD(lEvent) is index)



//-----sub-function defines for lParam of okSetConvertParam
#define		CONVERT_RESETALL		0 //reset all to sys default
#define		CONVERT_FIELDEXTEND		1 //field extend
#define		CONVERT_TAKECHANNEL		2 //take some one channel of r,g,b
#define		CONVERT_HORZEXTEND		3 //horzental extend (integer times)
#define		CONVERT_HORZSTRETCH		4 //horzental stretch (arbitrary number times)


//field extend mode
#define		FIELD_JUSTCOPY			0 //just copy row by row 
#define		FIELD_COPYEXTEND		1 //copy one row and expend one row (x2)
#define		FIELD_INTERLEAVE		2 //just copy odd(1.) rows (/2)
#define		FIELD_INTEREXTEND		3 //copy one odd row and expend one row 
#define		FIELD_COPYINTERPOL		4 //copy one odd row and interpolate one row
#define		FIELD_INTERINTERPOL		5 //copy odd row and interpolate even row

#define		FIELD_INTEREVEN			6 //just copy even(2.) rows (/2)
#define		FIELD_INTEREXTEVEN		7 //copy one even row and expend one row 
#define		FIELD_JUSTCOPYODD		8 //just copy odd rows to odd rows  
#define		FIELD_JUSTCOPYEVEN		9 //just copy even rows to even rows  
#define		FIELD_ODDEVENCROSS		10 //copy odd and even crossly 




//-----defines for several target we can support 
typedef	LPARAM	TARGET;

#define		BUFFER		(TARGET)1	//Buffer(physical) allocated from host memory
#define		VIDEO		(TARGET)0	//Video source input to the board 
#define		SCREEN		(TARGET)-1	//Screen supported by VGA
#define		FRAME		(TARGET)-2	//Frame buffer on the board
#define		MONITOR		(TARGET)-3	//Monitor supported by (D/A) TV standard
#define		USERMEMORY	(TARGET)-4
#define		USERFILE	(TARGET)-5

#define		SEQFILE			0x5153	//SQ 
#define		BMPFILE			0x4d42	//BM

#define		BLKHEADER		0x4b42	//BK
#define		BUFHEADER		0x4642	//BF

//-----defines messages for user 

#define	WM_CLOSEREPLAY			WM_USER+100
		//send this message when close replay dlg

#define	WM_BEGINSEQPROC			WM_USER+101
		//begin seq proc, wParam=hBaord
#define	WM_SEQPROGRESS			WM_USER+102
		//seq in progress, wParam=hBaord, lParam=No. to
#define	WM_ENDSEQPROC			WM_USER+103
		//end seq proc, wParam=hBaord

//-----------struct defines---------------

//--app user used struct
typedef struct _boardtype {
	short	iBoardTypeCode; //ok board type code 
	char	szBoardName[22]; //board name (eg."OK_M20H")
} BOARDTYPE, *LPBOARDTYPE; //24 bytes


//image file block size
typedef struct _blocksize {
	short	iWidth;		//width
	short	iHeight;	//height
	short	iBitCount; //pixel bytes iBitCount
	short	iFormType;	//rgb format type, need to fill when RGB565 or RGB 555
	long	lBlockStep; //block stride (step to next image header)
						//need to fill when treat multi block else set 0
}BLOCKSIZE;



//image block info
typedef struct _blockinfo {
	short	iType;	//=BK or SQ, BM
	//struct _blocksize;
	short	iWidth;		//width
	short	iHeight;	//height
	short	iBitCount; //pixel bytes iBitCount
	short	iFormType;	//rgb format type, need to fill when RGB565 or RGB 555
	short	lBlockStep; //block stride (step to next image header)
	short	iHiStep;// HIWORD of block stride
	short	lTotal;	//frame num
	short	iHiTotal;// HIWORD of total
	short	iInterval; //frame interval
	LPBYTE	lpBits;// image data pointer / file path name
	LPBYTE	lpExtra;// extra data (like as palette, mask) pointer
} BLOCKINFO, *LPBLOCKINFO;

//sequence file info
typedef struct { //file info for seq
	short	iType;	//=SQ or BM
	//struct _blocksize;
	short	iWidth;		//width
	short	iHeight;	//height
	short	iBitCount; //pixel bytes iBitCount
	short	iFormType;	//rgb format type, need to fill when RGB565 or RGB 555
	short	lBlockStep; //block stride (step to next image header)
	short	iHiStep;// HIWORD of block stride
	short	lTotal;	//frame num
	short	iHiTotal;// HIWORD of total
	short	iInterval; //frame interval
} SEQINFO;

//for replay
typedef struct { //file info for seq
	LPBITMAPINFOHEADER	lpbi; //bitmap info
	BYTE			*lpdib; //dib data
	HWND			hwndPlayBox; //1 replaying, 0 quit
	short			iCurrFrame; //current frame in buffer
	short			iReserved; //
} DIBINFO, *LPDIBINFO;



//------ okapi32 functions list -----------

#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif /* __cplusplus */


//--1. basic routines--------------

//prolog and epilog
HANDLE	WINAPI okOpenBoard(long *iIndex); //okLockBoard
		//open a Ok series board in specified index(0 based), return 0 if not found any
		//if success, return a handle to control specified board
		//if set index=-1, mean takes default index no. (default is 0 
		//if user not specified by 'Ok Device Manager' in Control Pannel)
		//this index can be also a specified board type code
		//this function will change iIndex to the true used index, 
		//if index input is -1 or type code 

BOOL	WINAPI okCloseBoard(HANDLE hBoard); //okCloseBoard
		//Unlock and close Ok board specified handle
long	WINAPI okGetLastError();
		//Get last error msg

long	WINAPI okGetBufferSize(HANDLE hBoard, void **lpLinear, DWORD *dwSize);
		//get base address and size of pre-allocated buffer,
		//if success return the max. frame num in which can be store according to current set
		//else return false;
LPVOID  WINAPI okGetBufferAddr(HANDLE hBoard, long lNoFrame);
		//get base address of specified frame No. in BUFFER
		//if success return the linear base address 
		//else return false;

LPVOID  WINAPI okGetTargetInfo(HANDLE hBoard, TARGET tgt, long lNoFrame, short * wid, short * ht, long *stride);
		//get target info include base address, width, height and stride specified frame No. 
		//if success return the linear base address and other infos, else return false;

short	WINAPI okGetTypeCode(HANDLE hBoard, LPSTR lpBoardName);
		//return type code and name of specified handle 


//set rect and capture 
long	WINAPI okSetTargetRect(HANDLE hBoard, TARGET target, LPRECT lpTgtRect);
		//set target (VIDEO, SCREEN, BUFFER, FRAME)capture to or from
		//if Rect.right or .bottom) are -1 , they will be filled current value
		//special note for target=BUFFER:
		//if never set CAPTURE_BUFBLOCKSIZE, the block size(W,H) of buffer will be changed 
		//according to size of right x bottom of lpRect, else the size will not changed 
		//if success return max frames this target can support, else return <=0

BOOL	WINAPI okSetToWndRect(HANDLE hBoard, HWND hWnd);
		//set client rect of hwnd as screen rect


BOOL	WINAPI okCaptureTo(HANDLE hBoard, TARGET Dest, WORD wParam, LPARAM lParam);
		//capture video source to target which can be BUFFER, SCREEN, FRAME, MONITOR 
		//wParam=start(o based), lParam>0: number of frame to capture to, =0: cont. mode,
 		//if lParam > total frames in BUFER, it will loop in rewind mode(i%total)
		//if lParam=-1 mean it loop infinitely until call okStopCapture
		//return max num frame can be stored in the target if success,
		// return 0 if failed(eg. format not matched). -1 not support target
		//this call will return immediately not wait to finish.
		//
BOOL	WINAPI okCaptureToScreen(HANDLE hBoard);
		//Start to capture to screen (video real-time display on screen) and return immediately
		//this is just a special routine of okCaptureTo(hBoard,SCREEN,0,0)

BOOL	WINAPI okPlaybackFrom(HANDLE hBoard, TARGET src, WORD wParam, LPARAM lParam);
		//playback on monitor from target which can be BUFFER, FRAME
		//wParam=start(o based), lParam>0: number of frame to capture to, =0: cont. mode 
		//if lParam > total frames in BUFER, it will loop in rewind mode (i%total)
		//if lParam=-1 mean it loop infinitely until call okStopCapture
		//return max num frame be stored in the target if success, 
		//return 0 if wrong. -1 not support target
		//this call will return immediately not wait to finish.
		//

//get status and stop capture
long	WINAPI okGetCaptureStatus(HANDLE hBoard, BOOL bWait);
		//query capturing status, if bWait then wait to finish capturing, else return immediately.
		//return 0 if finished, if cont. mode capturing return target capture to
		//(which include SCREEN -1, FRAME -2, MONITOR -3)
		//if capturing to/from BUFFER or file, return the frame No.(1 based) being capturing 

BOOL	WINAPI okStopCapture(HANDLE hBoard);
		//Stop capturing to or playback from SCREEN, BUFFER or other targets 
		//return target just captured to or from. 
		//if capturing to/from BUFFER or file, return the frame No.(1 based) being capturing 


//capture by to /from 
BOOL	WINAPI okCaptureByBuffer(HANDLE hBoard, TARGET dest, short start, long num);
		//capture sequence images to dest by way of two frame buffers (in BUFFER), 
		//the frame size and format is taken as same as current config of BUFFER
		//if dest is file name which can be .seq or .bmp (will generate multi bmp files)
		//dest can be also a user memory pointer or a BLOCKINFO pointer (with user memory pointer)
		//retrun true immediately if success. num should be great than 0

		
BOOL	WINAPI okPlaybackByBuffer(HANDLE hBoard, TARGET src, short start, long num);
		//playback sequence images on monitor from src by way of two frame buffers (in BUFFER)
		//the size and format of BUFFER will be changed to same as src
		//src can be a file name which may be .seq or .bmp (first orderd bmp files) 
		////src can be also a BLOCKINFO pointer (with infos of user memory pointer,size and format)
		//if src is just user memory pointer, this function will think its block size and format 
		//are same as current config of BUFFER (in this case can not support loop function).
		//retrun true immediately if success 
		//if num is great than the true frame number in src, it will loop back
		//if num=-1 mean it will loop infinitely until call okStopCapture

//set and get params
long	WINAPI okSetVideoParam(HANDLE hBoard, WORD wParam, long lParam);
		//----set video param sub-function defines
		//set video param and return previous param; 
		//if input lParam=-1, just return previous param 			
		//if not support return -1, if error return -2 

long	WINAPI okSetCaptureParam(HANDLE hBoard, WORD wParam, long lParam);
		//set capture param and return previous param; 
		//if input lParam=-1, just return previous param 			
		//if not support return -1, if error return -2 


//transfer and convert rect
long	WINAPI okSetConvertParam(HANDLE hBoard, WORD wParam, long lParam);
		//set convert param for for function okConvertRect 
		//if not support return -1, if error return -2 

long	WINAPI okReadRect(HANDLE hBoard, TARGET src, short start, LPBYTE lpBuf);
		//read data into lpBuf from rect(set previous) in frame start of dst (SCREEN, BUFFER, FRAME)
		//the data in lpBuf stored in way row by row
		//if src not supported return -1, if failed return 0, 
		//return -1 if not support, return 0 failed, 
		//if success return data length read in byte
		//if lpBuf=NULL, just return data length to read

long	WINAPI okWriteRect(HANDLE hBoard, TARGET dst, short start, LPBYTE lpBuf);
		//write data in lpBuf to rect(set previous) of dst (SCREEN, BUFFER, FRAME)
		//the data in lpBuf stored in way row by row
		//return -1 if not support, return 0 failed, 
		//if success return data length written in byte

long	WINAPI okReadRectEx(HANDLE hBoard, TARGET src, short start, LPBYTE lpBuf, LPARAM lParam);
		//read data into lpBuf from rect(set previous) in frame start of dst (SCREEN, BUFFER, FRAME)
		//the data in lpBuf stored in way row by row
		//if src not supported return -1, if failed return 0, 
		//return -1 if not support, return 0 failed, 
		//if success return data length read in byte
		//if lpBuf=NULL, just return data length to read
		//LOWORD(lParamis form code for bits of lpBuf (e.g.FORM_GRAY8if it is 0 mean: as same as src
        //HIWORD(LParam) is the mode of taking channels. mode=0 take all, =1 red, =2 green, =3 blue;

long	WINAPI okWriteRectEx(HANDLE hBoard, TARGET dst, short start, LPBYTE lpBuf, LPARAM lParam);
		//write data in lpBuf to rect(set previous) of dst (SCREEN, BUFFER, FRAME)
		//the data in lpBuf stored in way row by row
		//return -1 if not support, return 0 failed, 
		//if success return data length written in byte
		//LOWORD(lParamis form code for bits of lpBuf (e.g.FORM_GRAY8if it is 0 mean: as same as dst
        //HIWORD(LParam) is the mode of taking channels. mode=0 take all, =1 red, =2 green, =3 blue;

long	WINAPI okTransferRect(HANDLE hBoard, TARGET dest, short iFirst, TARGET src, short iStart, long lNum);
		//transfer source rect to dest rect (here target can be SCREEN, BUFFER, FRAME, also BLOCKINFO point to user memory) 
		//if total in dest or src less than lNum, it will rewind to begin then continue
		//this function transfer in format of src, that means it don't convert pixel bits if dst and src are not same 
		//if src or dst not supported return -1, if failed return 0, 
		//if success return data length of one block image in byte

long	WINAPI okConvertRect(HANDLE hBoard, TARGET dst, short first, TARGET src, short start, LPARAM lParam);
		//transfer source rect to dest rect (here target can be SCREEN, BUFFER, FRAME, also BLOCKINFO point to user memory) 
		//LOWORD(lParam)=lNum, total num, HIWORD(lParam)=mode, channels to convert
		//mode=0 take all, =1 red, =2 green, =3 blue;
		//if total in dest or src < lNum, it will rewind to begin then continue
		//this function convert to pixel foramt of dst if dst has not same bits format as src 
		//if src or dst not supported return -1, if failed return 0, 
		//if success return image size of one block in pixel

long	WINAPI okConvertRectEx(HANDLE hDstBoard, TARGET dst, short first, HANDLE hSrcBoard, TARGET src, short start, LPARAM no);
		//same as the above function okConvertRect except with src handle

	
long	WINAPI okGetSignalParam(HANDLE hBoard, WPARAM wParam);
		//Get specified param of video signal source
		//if not support return -1, if error return -2, else return param

long	WINAPI okWaitSignalEvent(HANDLE hBoard, WPARAM wParam, LPARAM lMilliSecond);
		//Wait specified signal come
		//lMilliSecond is time-out time in milliseconds for to wait
		//if lMilliSecond is zero, the function returns current state immediately
		//if lMilliSecond is INFINITE(-1) wait forever until event come
		//return -1 not support, 0 speicfied signal not come, 1 come


BOOL	WINAPI okSetSeqProcWnd(HANDLE hBoard, HWND hwndMain);
		//set proc hwnd for receive message about sequence capture

BOOL	WINAPI okSetSeqCallback(HANDLE hBoard, 
								BOOL CALLBACK BeginProc(HANDLE hBoard), 
								BOOL CALLBACK SeqProc(HANDLE hBoard, long No), 
								BOOL CALLBACK EndProc(HANDLE hBoard));
		//set callback function for multi-frame capturing function 
		//(which are okCaptureTo, okCaptureFrom,okCaptureToFile, okCaptureFromFile)
		//see follow 

BOOL	CALLBACK BeginProc(HANDLE hBoard); //user defined callback function
		//callback this function before to capture
BOOL	CALLBACK SeqProc(HANDLE hBoard, long No); //user defined callback function
		// callback this function after finish capturing one frame
		// No is the number(0 based) frame just finished or being playbacked. 
BOOL	CALLBACK EndProc(HANDLE hBoard); //user defined callback function
		// callback this function after end capturing

//---overlay mask:
long	WINAPI okEnableMask(HANDLE hBoard, BOOL bMask);
		//0: disable mask; 1: positive mask, 2: negative mask
		//positive: 0 for win clients visible, 1 video visible
		//negative: 0 for video visible,  1 for win client (graph) visible
		//if bMask=-1 actually not set just get status previous set
		//return last mask status,
 
long	WINAPI okSetMaskRect(HANDLE hBoard, LPRECT lpRect, LPSTR lpMask);
		//Set mask rect(lpRect is relative to lpDstRect in SetScreenRect or
		//SetBufferRect, lpMask is mask code (in byte 0 or 1). one byte for one pixel
		//if lpMask==1, set all rect region in lpRect video visible
		//if lpMask==0, set all rect region in lpRect video unvisible
		//return base linear address of inner mask bit 

//---set out LUT:
long	WINAPI okFillOutLUT(HANDLE hBoard,  LPBYTE bLUT, short start, short num);
		//fill specified playback out LUT. 
		//bLut stored values to fill, (r0,g0,b0, r1,g1,b1 ...)
		//start: offset pos in LUT(based 0), num: num items to fill


//---multi cards access--------
short	WINAPI okGetSlotBoard(BOARDTYPE **lpOkInfo);
		//Query all Ok boards available in PCI bus, return total number
short	WINAPI okGetBoardIndex(char *szBoardName, short iNo);
		//Get index (start 0) of specified board name string (it can also be typcode string)
		// and order in same name (start 0), 
		//return -1 if no this specified ok board
short	WINAPI okGetBoardName(long lIndex, LPSTR szBoardName);
		//get the board code and name of the specified index 
		//return the type code if success else return 0 if no card

BOOL	WINAPI okLoadInitParam(HANDLE hBoard, short iChannNo);
		//load specified chann (and as current chann.)of initial params
BOOL	WINAPI okSaveInitParam(HANDLE hBoard, short iChannNo);
		//save current init param to specified chann (and as current chann.)


long	WINAPI okGetAvailBuffer(void **lpLinear, DWORD *dwSize);
		//Get free meomery buffers pre-allocated . 
		//call it when user hope to access buffer directly or lock for some one board 
long	WINAPI okLockBuffer(HANDLE hBoard, DWORD dwSizeByte, void **lpBasLinear);
		//Lock speicfiled size meomery buffers, then other handle can not use them
		//return the size of locked buffer in fact
BOOL	WINAPI okUnlockAllBuffer(void);
		//Unlock all buffer for all handle

BOOL	WINAPI 	okMulCaptureTo(HANDLE *lphBaord,TARGET Dest, WORD wParam, LPARAM lParam);
		//control multi boards to capture to target simultaneously, lphBaord are pointer of hBoard of multi board  
		//other functions are same as okCaptureByBuffer

BOOL	WINAPI 	okMulCaptureByBuffer(HANDLE *lphBaord,TARGET tgt, short start, long num);
		//control multi boards to capture by buffer simultaneously, lphBaord are pointer of hBoard of multi board  
		//other functions are same as okCaptureByBuffer


//-- set pre-allocate buffer size in k byte
long	WINAPI okSetAllocBuffer(long lSize);
		//set the new size to preallocate in k bytes, 
		//if new size is not same as current, 
		//then the functuion will restart the window system

BOOL	WINAPI okSetStaticVxD(long lMode);
		//lMode=0: check if static vxd registered.
		//=1: create static vxd register
		//=2: delete static vxd register

//---apps utilities-----------------

//save and load files
long WINAPI okSaveImageFile(HANDLE hBoard, LPSTR szFileName, long first, TARGET target, long start, long num);
	//here target can be BUFFER, SCREEN, FRAME or user buffer pointor
	//1.if ext name=".bmp":
	//create new file and than save one frame in start position of target as bmp file 
	//
	//2.if ext name=".seq":
	//save no frame from (start) in target into (first) frame pos in seq(sequence) file in sequencely.
	//if the file already exist the function will not delete it, that mean old contents in the file will be kept.
	//So if you want create a new seq file with a existed file name you must delete before this call .
	//

long WINAPI okLoadImageFile(HANDLE hBoard, LPSTR szFileName, long first, TARGET target, long start, long num);
	//here target can be BUFFER, SCREEN, FRAME or user buffer pointor
	//1.if ext name=".bmp":
	//load one frame into start position of target from bmp file 
	//
	//2.if ext name=".seq":
	//load no frame into (start) in target from (first) frame pos in seq(sequence) file in sequencely.



//apps setup dialog 
BOOL WINAPI okOpenSetParamDlg( HANDLE hBoard, HWND hParentWnd);
	//dialog to setup video param 
BOOL WINAPI okOpenSeqCaptureDlg( HANDLE hBoard, HWND hParentWnd);
	//dialog to capture sequence image

LPDIBINFO WINAPI okOpenReplayDlg( HANDLE hBoard, HWND hWnd, TARGET src, long total);
	//open modeless dialog to replay sequence images(in BUFFER, USERBUF or seq file) on SCREEN or MONITOR

#ifdef __cplusplus
}
#endif    /* __cplusplus */




//-------------------end--------------------------
