Attribute VB_Name = "Define"
Option Explicit
'==============================================================================
'
'       filename        define.bas
'       purpose         define for okcard.ocx
'       language        Microsoft Visual Basic 5.0
'       author          H. Peng
'       date            2000.5.18
'-----------------------
'       modify by       H. Peng
'       purpose
'       language        Microsoft Visual Basic 5.0
'       date            2000.5
'
'-----------------------
'
'       Copyright (C).  All Rights Reserved.
'
'
'==============================================================================

'---------------define.bas---------------------------------
'
' ok api32 header file for user
'
'---------------------------------------------------------

'----contant defines----

'--defines of ok series image board identity
'Mono series
Public Const OK_M10 = 1010
Public Const OK_M10N = 1010
Public Const OK_M10M = 1013
Public Const OK_M10F = 1011
Public Const OK_M10L = 1014
Public Const OK_M10H = 1012
Public Const OK_M20 = 1020
Public Const OK_M2KC = 1021

Public Const OK_M20H = 1022
Public Const OK_M30 = 1030
Public Const OK_M40 = 1040
Public Const OK_M50 = 1050
Public Const OK_M60 = 1060
Public Const OK_M70 = 1070
Public Const OK_M80 = 1080
Public Const OK_M80K = 1081
Public Const OK_M90 = 1090

'--new updated series
Public Const OK_M10A = 1210
Public Const OK_M10B = 1213                       'OK_M10M:1013
Public Const OK_M10C = 1214                       'OK_M10L/N:1014
Public Const OK_M10D = 1215
Public Const OK_M10K = 1218                       'OK_M80K


Public Const OK_M20A = 1222                       'OK_M20H:1022
Public Const OK_M20B = 1223                       '110M
Public Const OK_M20C = 1224                       '160M
Public Const OK_M20D = 1225                       '2050M

Public Const OK_M40A = 1240                       'OK_M40:1041
Public Const OK_M40B = 1243                       '110M
Public Const OK_M40C = 1244                       '160M
Public Const OK_M40D = 1245                       '205M

Public Const OK_M60A = 1260                       'OK_M60:1060
Public Const OK_M60B = 1263                       '110M
Public Const OK_M60C = 1264                       '160M
Public Const OK_M60D = 1265                       '205M

Public Const OK_M50A = 1250
Public Const OK_M50K = 1258

'64 bits series
Public Const OK_DM20B = 1223                      '140M
Public Const OK_DM20C = 1224                      '160M
Public Const OK_DM20D = 1225                      '205M

'PCI_X seriesC
Public Const OK_XM20_140 = 1323

'Color series
Public Const OK_C20 = 2020
Public Const OK_C20C = 2021
Public Const OK_C30 = 2030
Public Const OK_C30S = 2031
Public Const OK_C40 = 2040
Public Const OK_C50 = 2050
Public Const OK_C70 = 2070
Public Const OK_C80 = 2080
Public Const OK_C80M = 2081

Public Const OK_RGB10 = 3010
Public Const OK_RGB20 = 3020
Public Const OK_RGB30 = 3030

'---mc series
Public Const OK_MC10 = 4010
Public Const OK_MC10A = 4011
Public Const OK_MC16 = 4016
Public Const OK_MC20 = 4020
Public Const OK_MC30 = 4030

'--new updated series
Public Const OK_C20A = 2220
Public Const OK_C20B = 2223
Public Const OK_C30A = 2230
Public Const OK_C31A = 2231
Public Const OK_C30B = 2233
Public Const OK_C40A = 2240
Public Const OK_C50A = 2250
Public Const OK_C60A = 2260
Public Const OK_C80A = 2280

Public Const OK_RGB10A = 3210
Public Const OK_RGB10B = 3213

Public Const OK_RGB20A = 3220
Public Const OK_RGB20B = 3223
Public Const OK_RGB20C = 3224

Public Const OK_RGB30A = 3230
Public Const OK_RGB30B = 3233
Public Const OK_RGB30C = 3234

'---usb series
Public Const OK_USB20 = 5220

'---pc104+ series
Public Const OK_PC10 = 5210


'--error code

Public Const ERR_NOERROR = 0                  'no error
Public Const ERR_NOTFOUNDBOARD = 1            'not found available ok board

Public Const ERR_NOTFOUNDVXDDRV = 2           'not found ok vxd driver
Public Const ERR_NOTALLOCATEDBUF = 3          'not pre-allocated buffer from host memory
Public Const ERR_BUFFERNOTENOUGH = 4          'available buffer not enough requirment
Public Const ERR_BEYONDFRAMEBUF = 5           'capture iamge size beyond buffer

Public Const ERR_NOTFOUNDDRIVER = 6           'no driver found
Public Const ERR_NOTCORRECTDRIVER = 7         'driver not correct

Public Const ERR_MEMORYNOTENOUGH = 8          'memory not enough
Public Const ERR_FUNNOTSUPPORT = 9            'the function not support
Public Const ERR_OPERATEFAILED = 10           'something wrong with the operation

Public Const ERR_HANDLEAPIERROR = 11          'the handle to okapi function wrong
Public Const ERR_DRVINITWRONG = 12            'something wrong with driver initialize

Public Const ERR_RECTVALUEWRONG = 13          'the rect set wrong
Public Const ERR_FORMNOTSUPPORT = 14          'the form set not support by the board

Public Const ERR_TARGETNOTSUPPORT = 15        'the target not support by this function

'--format defines
Public Const FORM_RGB888 = 1
Public Const FORM_RGB565 = 2
Public Const FORM_RGB555 = 3
Public Const FORM_RGB8888 = 4
Public Const FORM_RGB332 = 5
Public Const FORM_RGB8886 = 18

Public Const FORM_YUV422 = 6
Public Const FORM_YUV411 = 7
Public Const FORM_YUV16 = 8
Public Const FORM_YUV12 = 9
Public Const FORM_YUV9 = 10
Public Const FORM_YUV8 = 11

Public Const FORM_GRAY888 = 12
Public Const FORM_GRAY8888 = 13
Public Const FORM_GRAY8 = 14
Public Const FORM_GRAY10 = 15
Public Const FORM_GRAY12 = 16
Public Const FORM_GRAY16 = 17



'--mask command
Public Const MASK_DISABALE = 0                'turn of mask
Public Const MASK_POSITIVE = 1                '0 win clients visible, 1 video visible
Public Const MASK_NEGATIVE = 2                '0 for video 1 for win client (graph)


'--tv system standard
Public Const TV_PALSTANDARD = 0               'PAL
Public Const TV_NTSCSTANDARD = 1              'NTSC
Public Const TV_NONSTANDARD = 2               'NON_STD


Public Const TV_PALMAXWIDTH = 768
Public Const TV_PALMAXHEIGHT = 576

Public Const TV_NTSCMAXWIDTH = 640            '720
Public Const TV_NTSCMAXHEIGHT = 480

Public Const GWL_WNDPROC = (-4)
Public Const GWL_USERDATA = (-21)


'-----defines lParam for get param
Public Const GETCURRPARAM = -1

'-----sub-function defines for wParam of SetVideoParam
        'wParam cab be one of the follow
Public Const VIDEO_RESETALL = 0             'reset all to sys default
Public Const VIDEO_SOURCECHAN = 1
            ' lParam=0,1.. Comp.Video; 0x100,101...to Y/C(S-Video), 0x200,0x201 to RGB Chan.Input
Public Const VIDEO_BRIGHTNESS = 2           'LOWORD is brightness, for RGB HIWORD is channel (0:red, 1:green, 2:blue)
Public Const VIDEO_CONTRAST = 3             'LOWORD is contrast, for RGB HIWORD is channel (0:red, 1:green, 2:blue)
Public Const VIDEO_COLORHUE = 4
Public Const VIDEO_SATURATION = 5
Public Const VIDEO_RGBFORMAT = 6              'when return low word  is code high word is bitcount
Public Const VIDEO_TVSTANDARD = 7             '0 PAL, 1 NTSC, 2 Non-stadard
Public Const VIDEO_SIGNALTYPE = 8             'LOWORD 0 non-interlaced, 1 interlaced
                                        'HIWORD 0 no slot in field header, 1 yes
Public Const VIDEO_RECTSHIFT = 9              'malelong (x,y)
Public Const VIDEO_SYNCSIGCHAN = 10           'LOWORD 0:Red,1:Grn,2:Blue, 3:Sync;
                                        'HIWORD is source 0,1,..for RGB input,
                                        ' 0x100,0x101,... for comp.video input
                                        ' ( in this case LOWORD has not mean more)
Public Const VIDEO_SIGREFVOLTAGE = 11
Public Const VIDEO_AVAILRECTSIZE = 12         'makelong(horz,vert)
                'horz available pixels per scan line and
                'vert available lines per frame
Public Const VIDEO_FREQSEG = 13               ' set horz video frequency range
                                        '0:Low(7.5~15MHz),  1:middle(15~30), 2:High(30~60)
Public Const VIDEO_LINEPERIOD = 14           'line period (in 0.5 us) generated by board
Public Const VIDEO_FRAMELINES = 15           'lines per frame  generated by board

Public Const VIDEO_MISCCONTROL = 16          'miscellaneous control bits

    
    
'-----sub-function defines for wParam of SetCaptureParam
        'wParam cab be one of the follow
Public Const CAPTURE_RESETALL = 0           'reset all to sys default
Public Const CAPTURE_INTERVAL = 1
Public Const CAPTURE_CLIPMODE = 2           'LOWORD: clip mode when video and dest rect not same size
                                            'HIWORD: if captrure odd and even field crosslly
Public Const CAPTURE_SCRRGBFORMAT = 3       'when return, loword=code, hiword=bits
Public Const CAPTURE_BUFRGBFORMAT = 4
Public Const CAPTURE_FRMRGBFORMAT = 5
Public Const CAPTURE_BUFBLOCKSIZE = 6       'lParam=MAKELONG(width,height)
                                            'if set it 0 (default), the rect set by user will be as block size
Public Const CAPTURE_HARDMIRROR = 7         'bit0 x, bit1 y;
Public Const CAPTURE_VIASHARPEN = 8         'sample via sharpen filter
Public Const CAPTURE_VIAKFILTER = 9         'sample via recursion filter
Public Const CAPTURE_SAMPLEFIELD = 10       '0 in field (non-interlaced), 1 in frame (interlaced), (0,1 are basic)
                                            '2 in field but keep expend row,3 in field but interlaced one frame
                                            '(2,4 can affect only sampllng field(frame) by field(frame) )
                                            'in 3 up-dn frame
Public Const CAPTURE_HORZPIXELS = 11        ' set max horz pixel per scan line
Public Const CAPTURE_VERTLINES = 12         ' set max vert lines per frame

Public Const CAPTURE_ARITHMODE = 13         'arithmatic mode
Public Const CAPTURE_TO8BITMODE = 14        'the mode of high (eg. 10 bits) converted to 8bit
                                            'HIWORD(lParam)=0: linear scale,
                                            'HIWORD(lParam)!=0:clip mode, LOWORD(lParam)=offset
Public Const CAPTURE_SEQCAPWAIT = 15        ' bit0 if waiting finished for functions of sequence capturing and playbacking
                                            'bit1 if waiting finished capture then call callback function

Public Const CAPTURE_MISCCONTROL = 16       'miscellaneous control bits
                                            'bit0: 1: take one by one |okCapturByBuffer,okGetSeqCapture by interrupt control
                                            'bit1: 1: take last one   |
                                            
Public Const CAPTURE_TRIGCAPDELAY = 17      'set delay capture by trigger
Public Const CAPTURE_TURNCHANNELS = 18      'turn channel when sequence capture



'-----defines lParam for CAPTURE_CLIPMODE
Public Const RECT_SCALERECT = 0
Public Const RECT_CLIPCENTER = 1
Public Const RECT_FIXLEFTTOP = 2
        'in condition video rect great than screen rect:
        'if RECT_SCALERECT video rect will be scaled to match screen rect if it can. else
        'video rect will be adjusted to match screen rect
        '(1: center, take center video rect  2: left-top fixed, take same size rect)


'-----sub-function defines for lParam of GetSignalParam
Public Const SIGNAL_VIDEOEXIST = 1          '0 video  absent, 1 exist
Public Const SIGNAL_VIDEOTYPE = 2           '0 field, 1 interlaced
Public Const SIGNAL_SCANLINES = 3           'scan lines per frame
Public Const SIGNAL_LINEFREQ = 4            'line frequency
Public Const SIGNAL_FIELDFREQ = 5           'frame frequency
Public Const SIGNAL_FRAMEFREQ = 6           'frame frequency
Public Const SIGNAL_EXTTRIGGER = 7          'extern trigger status


'-----sub-function defines for lEvent of WaitSignalEvent
Public Const EVENT_FIELDHEADER = 1          'field header
Public Const EVENT_FRAMEHEADER = 2          'frame header
Public Const EVENT_ODDFIELD = 3             'odd field come
Public Const EVENT_EVENFIELD = 4            'even field come
Public Const EVENT_EXTTRIGGER = 5           'extern trigger come,
                                      '(HIWORD(lEvent) is index)

'-----sub-function defines for lParam of PutSignalParam
Public Const PUTSIGNAL_TRIGGER = 1          'put trigger signal, 1 trigger


'-----sub-function defines for lParam of okSetConvertParam
Public Const CONVERT_RESETALL = 0           'reset all to sys default
Public Const CONVERT_FIELDEXTEND = 1        'field extend
Public Const CONVERT_TAEKCHANNEL = 2        'take some one channel of r,g,b

'field extend mode
Public Const FIELD_JUSTCOPY = 0             'just copy row by row
Public Const FIELD_COPYEXTEND = 1           'copy one row and expend one row (x2)
Public Const FIELD_INTERLEAVE = 2           'just copy odd(1.) rows (/2)
Public Const FIELD_INTEREXTEND = 3          'copy one odd row and expend one row

Public Const FIELD_INTEREVEN = 4            'just copy even(2.) rows (/2)
Public Const FIELD_INTEREXTEVEN = 5         'copy one even row and expend one row
Public Const FIELD_JUSTCOPYODD = 6          'just copy odd rows to odd rows
Public Const FIELD_JUSTCOPYEVEN = 7         'just copy even rows to even rows
Public Const FIELD_ODDEVENCROSS = 8         'copy odd and even crossly



'-----defines for several target we can support
'typedef LPARAM  TARGET;

Public Const BUFFER = 1           'Buffer(physical) allocated from host memory
Public Const VIDEO = 0            'Video source input to the board
Public Const SCREEN = -1          'Screen supported by VGA
Public Const FRAME = -2           'Frame buffer on the board
Public Const MONITOR = -3         'Monitor supported by (D/A) TV standard


Public Const SEQFILE = &H5153             'SQ
Public Const BMPFILE = &H4D42             'BM

Public Const BLKHEADER = &H4B42           'BK

'-----defines messages for user

Public Const WM_USER = &H400

Public Const WM_CLOSEREPLAY = WM_USER + 100
        'send this message when close replay dlg

Public Const WM_BEGINSEQPROC = WM_USER + 101
        'begin seq proc, wParam=hBaord
Public Const WM_SEQPROGRESS = WM_USER + 102
        'seq in progress, wParam=hBaord, lParam=No. to
Public Const WM_ENDSEQPROC = WM_USER + 103
        'end seq proc, wParam=hBaord

'sequence file info
Type tpSeqInfo 'file info for seq
    iType As Integer   '=SQ or BM
    'struct _blocksize;
    iWidth As Integer      'width
    iHeight As Integer     'height
    iBitCount As Integer  'pixel bytes iBitCount
    iFormType As Integer   'rgb format type, need to fill when RGB565 or RGB 555
    lBlockStep As Long  'block stride (step to next image header)

    lTotal As Long  'frame num
    iInterval As Integer  'frame interval
End Type

Type tpBlockInfo
    iType As Integer   '=BK or SQ, BM
    'struct _blocksize;
    iWidth As Integer  'width
    iHeight As Integer 'height
    iBitCount As Integer  'pixel bytes iBitCount
    iFormType As Integer   'rgb format type, need to fill when RGB565 or RGB 555
    lBlockStep As Integer  'block stride (step to next image header)
    iHiStep  As Integer 'HIWORD of block stride
    lTotal As Integer  'frame num
    iHiTotal As Integer  'HIWORD of total
    iInterval As Integer  'frame interval
    
    lpBits As Long ' image data pointer / file path name
    lpExtra As Long ' extra data (like as palette, mask) pointer
End Type


'-----------------------MyDefine------------------
Public DefaultTitle As String
Public Const NUMINFILE = 30
Dim Elapsed As Long
Dim Numframe As Long
Dim sTem As String
Dim iFrm As Integer
Dim Blk As tpBlockInfo

'-----------------------WinDefine-----------------
Public Const OF_EXIST = &H4000
Public Const OFS_MAXPATHNAME = 128

Type RECT
        Left As Long
        Top As Long
        Right As Long
        Bottom As Long
End Type

Type OFSTRUCT
        cBytes As Byte
        fFixedDisk As Byte
        nErrCode As Integer
        Reserved1 As Integer
        Reserved2 As Integer
        szPathName(OFS_MAXPATHNAME) As Byte
End Type

Declare Function InvalidateRect Lib "user32" (ByVal hWnd As Long, lpRect As RECT, ByVal bErase As Long) As Long
Declare Function OpenFile Lib "kernel32" (ByVal lpFileName As String, lpReOpenBuff As OFSTRUCT, ByVal wStyle As Long) As Long
Declare Function GetTickCount Lib "kernel32" () As Long
Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" (ByVal hWnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Public Declare Function CallWindowProc Lib "user32" Alias "CallWindowProcA" (ByVal lpPrevWndFunc As Long, ByVal hWnd As Long, ByVal Msg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long

Public buf(5000000) As Byte

Public pOld As Long

Public total As Integer             'ȫɼ
Public lpDibPlay As Long

Function WindowProc(ByVal hw As Long, ByVal uMsg As Long, _
      ByVal wParam As Long, ByVal lParam As Long) As Long

    
    Select Case uMsg
    Case WM_BEGINSEQPROC:
        exBeginCapture
    Case WM_SEQPROGRESS:
        exBackDisplay lParam
    Case WM_ENDSEQPROC:
        exEndCapture
'    Case WM_ASKWAITVERTICAL:
'        okWaitVerticalSync hBoard, False
    Case Else
        Dim lpPrevWndProc As Long
        'ѯԭĬϵĴڹָ
'        lpPrevWndProc = GetWindowLong(hw, GWL_USERDATA)
         'ԭĴڹ
        'WindowProc = CallWindowProc(lpPrevWndProc, hw, uMsg, wParam, lParam)
        WindowProc = CallWindowProc(pOld, hw, uMsg, wParam, lParam)
        
    End Select
      

End Function
 

Function LoByte(ByVal Value As Long) As Byte
'ȡValueĵλ
Dim k As Integer

k = Value
Do While (k > 255)
    k = k - 256
Loop
LoByte = k
End Function

Function funMin(ByVal Param1 As Long, ByVal Param2 As Long) As Long
'Param1Param2нС
If Param1 > Param2 Then
    funMin = Param2
Else
    funMin = Param1
End If
End Function

Sub exBackDisplay(ByVal no As Long)
    'Իص
    Dim lNo As Long
    
    
    Numframe = Numframe + 1
    
    sTem = "Total frames = " + Trim(Str(Numframe)) + "; Current = " + Trim(Str(no))
    mainFrm.Caption = sTem
    
    mainFrm.OkCard1.ShowCallbackFrame no
End Sub

Sub exBeginCapture()
    'ʼɼص
    '    blk.lpBits=lpdib;
    '    form=GetBitmapData(hBoard, BUFFER, 0, lpbi, lpdib); //it is slow to get from screen
    '    blk.iBitCount=lpbi->biBitCount;
    '    blk.iWidth=(short)lpbi->biWidth;
    
    '    if( okSetCaptureParam(hBoard,CAPTURE_SAMPLEFIELD,-1)==0 ) //sample in field by field
    '        if( LOWORD(okSetVideoParam(hBoard,VIDEO_SIGNALTYPE,-1))==1 ) //interlace video
    '            lpbi->biHeight*=2; //double size for ht
    '    blk.iHeight=-(short)lpbi->biHeight; //note: minus is for invert dib in y by ConvertRect
    
    Elapsed = GetTickCount
    Numframe = 0
End Sub


Sub exEndCapture()
    'ֹɼص
    Elapsed = GetTickCount - Elapsed
    
    sTem = "Total frames = " + Trim(Str(Numframe)) + ";  elapsed time= " + Trim(Str(Elapsed)) + " ms"
    mainFrm.Caption = sTem
End Sub


Function MAKEWORD(ByVal bLow As Byte, ByVal bHigh As Byte) As Integer
Dim i As Long

i = bHigh
i = i * &H100 + bLow
If i < 32768 Then
    MAKEWORD = i
Else
    MAKEWORD = i - 65536
End If
End Function

Sub Sleep(Value As Integer)
Dim i As Long

For i = 1 To Value
    DoEvents
Next
End Sub


Function DetectFile(ByVal FileName As String) As Boolean
'ļ
Dim kk As OFSTRUCT
    
OpenFile FileName, kk, OF_EXIST
If kk.nErrCode <> 0 Then
    DetectFile = False
Else
    DetectFile = True
End If
End Function

Function HiWord(ByVal Value As Long) As Integer
'ȡValueĸλ
Dim k As Long
Dim i As Integer
Dim j As Integer

k = Value
For i = 1 To 8
    k = k \ 4
Next
j = k
HiWord = j
End Function


Function LoWord(ByVal Value As Long) As Integer
'ȡValueĵλ
Dim k As Long
Dim i As Integer
Dim j As Integer

k = Value
For i = 1 To 8
    k = k \ 4
Next
For i = 1 To 8
    k = k * 4
Next
j = Value - k
LoWord = j
End Function

