Attribute VB_Name = "okapi32"
'---------------okapi32.bas---------------------------------
'
' ok api32 header file for user
'
'---------------------------------------------------------

'----contant defines----

'--defines of ok series image board identity
'Mono series
Public Const OK_M10 = 1010
Public Const OK_M10N = 1010
Public Const OK_M10M = 1013
Public Const OK_M10F = 1011
Public Const OK_M10L = 1014
Public Const OK_M10H = 1012
Public Const OK_M20 = 1020
Public Const OK_M20C = 1021

Public Const OK_M20H = 1022
Public Const OK_M30 = 1030
Public Const OK_M40 = 1040
Public Const OK_M50 = 1050
Public Const OK_M60 = 1060
Public Const OK_M70 = 1070
Public Const OK_M80 = 1080
Public Const OK_M80K = 1081

Public Const OK_M10K = 1002

'Color series
Public Const OK_C20 = 2020
Public Const OK_C20C = 2021
Public Const OK_C30 = 2030
Public Const OK_C40 = 2040
Public Const OK_C40P = 2041
Public Const OK_C50 = 2050
Public Const OK_C70 = 2070
Public Const OK_C80 = 2080

Public Const OK_RGB10 = 3010
Public Const OK_RGB20 = 3020



'--error code

Public Const ERR_NOERROR = 0                  'no error
Public Const ERR_NOTFOUNDBOARD = 1            'not found available ok board

Public Const ERR_NOTFOUNDVXDDRV = 2           'not found ok vxd driver
Public Const ERR_NOTALLOCATEDBUF = 3          'not pre-allocated buffer from host memory
Public Const ERR_BUFFERNOTENOUGH = 4          'available buffer not enough requirment
Public Const ERR_BEYONDFRAMEBUF = 5           'capture iamge size beyond buffer

Public Const ERR_NOTFOUNDDRIVER = 6           'no driver found
Public Const ERR_NOTCORRECTDRIVER = 7         'driver not correct

Public Const ERR_MEMORYNOTENOUGH = 8          'memory not enough
Public Const ERR_FUNNOTSUPPORT = 9            'the function not support
Public Const ERR_OPERATEFAILED = 10           'something wrong with the operation

Public Const ERR_HANDLEAPIERROR = 11          'the handle to okapi function wrong
Public Const ERR_DRVINITWRONG = 12            'something wrong with driver initialize

Public Const ERR_RECTVALUEWRONG = 13          'the rect set wrong
Public Const ERR_FORMNOTSUPPORT = 14          'the form set not support by the board

Public Const ERR_TARGETNOTSUPPORT = 15        'the target not support by this function

'--format defines
Public Const FORM_RGB888 = 1
Public Const FORM_RGB565 = 2
Public Const FORM_RGB555 = 3
Public Const FORM_RGB8888 = 4
Public Const FORM_RGB332 = 5

Public Const FORM_YUV422 = 6
Public Const FORM_YUV411 = 7
Public Const FORM_YUV16 = 8
Public Const FORM_YUV12 = 9
Public Const FORM_YUV9 = 10
Public Const FORM_YUV8 = 11

Public Const FORM_GRAY888 = 12
Public Const FORM_GRAY8888 = 13
Public Const FORM_GRAY8 = 14
Public Const FORM_GRAY10 = 15
Public Const FORM_GRAY12 = 16
Public Const FORM_GRAY16 = 17



'--mask command
Public Const MASK_DISABALE = 0                'turn of mask
Public Const MASK_POSITIVE = 1                '0 win clients visible, 1 video visible
Public Const MASK_NEGATIVE = 2                '0 for video 1 for win client (graph)


'--tv system standard
Public Const TV_PALSTANDARD = 0               'PAL
Public Const TV_NTSCSTANDARD = 1              'NTSC
Public Const TV_NONSTANDARD = 2               'NON_STD


Public Const TV_PALMAXWIDTH = 768
Public Const TV_PALMAXHEIGHT = 576

Public Const TV_NTSCMAXWIDTH = 640            '720
Public Const TV_NTSCMAXHEIGHT = 480


'-----defines lParam for get param
Public Const GETCURRPARAM = -1

'-----sub-function defines for wParam of SetVideoParam
        'wParam cab be one of the follow
Public Const VIDEO_RESETALL = 0             'reset all to sys default
Public Const VIDEO_SOURCECHAN = 1
            ' lParam=0,1.. Comp.Video; 0x100,101...to Y/C(S-Video), 0x200,0x201 to RGB Chan.Input
Public Const VIDEO_BRIGHTNESS = 2           'LOWORD is brightness, for RGB HIWORD is channel (0:red, 1:green, 2:blue)
Public Const VIDEO_CONTRAST = 3             'LOWORD is contrast, for RGB HIWORD is channel (0:red, 1:green, 2:blue)
Public Const VIDEO_COLORHUE = 4
Public Const VIDEO_SATURATION = 5
Public Const VIDEO_RGBFORMAT = 6              'when return low word  is code high word is bitcount
Public Const VIDEO_TVSTANDARD = 7             '0 PAL, 1 NTSC, 2 Non-stadard
Public Const VIDEO_SIGNALTYPE = 8             'LOWORD 0 non-interlaced, 1 interlaced
                                        'HIWORD 0 no slot in field header, 1 yes
Public Const VIDEO_RECTSHIFT = 9              'malelong (x,y)
Public Const VIDEO_SYNCSIGCHAN = 10           'LOWORD 0:Red,1:Grn,2:Blue, 3:Sync;
                                        'HIWORD is source 0,1,..for RGB input,
                                        ' 0x100,0x101,... for comp.video input
                                        ' ( in this case LOWORD has not mean more)
Public Const VIDEO_SIGREFVOLTAGE = 11
Public Const VIDEO_AVAILRECTSIZE = 12         'makelong(horz,vert)
                'horz available pixels per scan line and
                'vert available lines per frame
Public Const VIDEO_FREQSEG = 13               ' set horz video frequency range
                                        '0:Low(7.5~15MHz),  1:middle(15~30), 2:High(30~60)
Public Const VIDEO_LINEPERIOD = 14           'line period (in 0.5 us) generated by board
Public Const VIDEO_FRAMELINES = 15           'lines per frame  generated by board

Public Const VIDEO_MISCCONTROL = 16          'miscellaneous control bits

    
    
'-----sub-function defines for wParam of SetCaptureParam
        'wParam cab be one of the follow
Public Const CAPTURE_RESETALL = 0           'reset all to sys default
Public Const CAPTURE_INTERVAL = 1
Public Const CAPTURE_CLIPMODE = 2           'LOWORD: clip mode when video and dest rect not same size
                                      'HIWORD: if captrure odd and even field crosslly
Public Const CAPTURE_SCRRGBFORMAT = 3       'when return, loword=code, hiword=bits
Public Const CAPTURE_BUFRGBFORMAT = 4
Public Const CAPTURE_FRMRGBFORMAT = 5
Public Const CAPTURE_BUFBLOCKSIZE = 6       'lParam=MAKELONG(width,height)
                                      'if set it 0 (default), the rect set by user will be as block size
Public Const CAPTURE_HARDMIRROR = 7           'bit0 x, bit1 y;
Public Const CAPTURE_SAMPVIALUT = 8           'set sample via lut
Public Const CAPTURE_VIAKFILTER = 9         'sample via recursion filter
Public Const CAPTURE_SAMPLEFIELD = 10        '0 in field (non-interlaced), 1 in frame (interlaced), 0,1 are basic
                                        '(2 in field but keep expend row,3 in field but interlaced one frame)
                                        ' 2,3 can affect only sampllng field(frame) by field(frame)
Public Const CAPTURE_HORZPIXELS = 11          ' set max horz pixel per scan line
Public Const CAPTURE_VERTLINES = 12           ' set max vert lines per frame

Public Const CAPTURE_ARITHMODE = 13          'arithmatic mode
Public Const CAPTURE_TO8BITMODE = 14         'the mode of high (eg. 10 bits) converted to 8bit
                                        'HIWORD(lParam)=0: linear scale,
                                        'HIWORD(lParam)!=0:clip mode, LOWORD(lParam)=offset
Public Const CAPTURE_SEQCAPWAIT = 15          ' bit0 if waiting finished for functions of sequence capturing and playbacking
                                        'bit1 if waiting finished capture then call callback function

Public Const CAPTURE_MISCCONTROL = 16        'miscellaneous control bits


'-----defines lParam for CAPTURE_CLIPMODE
Public Const RECT_SCALERECT = 0
Public Const RECT_CLIPCENTER = 1
Public Const RECT_FIXLEFTTOP = 2
        'in condition video rect great than screen rect:
        'if RECT_SCALERECT video rect will be scaled to match screen rect if it can. else
        'video rect will be adjusted to match screen rect
        '(1: center, take center video rect  2: left-top fixed, take same size rect)


'-----sub-function defines for lParam of GetSignalParam
Public Const SIGNAL_VIDEOEXIST = 1          '0 video  absent, 1 exist
Public Const SIGNAL_VIDEOTYPE = 2           '0 field, 1 interlaced
Public Const SIGNAL_SCANLINES = 3           'scan lines per frame
Public Const SIGNAL_LINEFREQ = 4            'line frequency
Public Const SIGNAL_FIELDFREQ = 5           'frame frequency
Public Const SIGNAL_FRAMEFREQ = 6           'frame frequency
Public Const SIGNAL_EXTTRIGGER = 7          'extern trigger status


'-----sub-function defines for lEvent of WaitSignalEvent
Public Const EVENT_FIELDHEADER = 1          'field header
Public Const EVENT_FRAMEHEADER = 2          'frame header
Public Const EVENT_ODDFIELD = 3             'odd field come
Public Const EVENT_EVENFIELD = 4            'even field come
Public Const EVENT_EXTTRIGGER = 5           'extern trigger come,
                                      '(HIWORD(lEvent) is index)



'-----sub-function defines for lParam of okSetConvertParam
Public Const CONVERT_RESETALL = 0           'reset all to sys default
Public Const CONVERT_FIELDEXTEND = 1        'field extend
Public Const CONVERT_TAEKCHANNEL = 2        'take some one channel of r,g,b

'field extend mode
Public Const FIELD_JUSTCOPY = 0             'just copy row by row
Public Const FIELD_COPYEXTEND = 1           'copy one row and expend one row (x2)
Public Const FIELD_INTERLEAVE = 2           'just copy odd(1.) rows (/2)
Public Const FIELD_INTEREXTEND = 3          'copy one odd row and expend one row

Public Const FIELD_INTEREVEN = 4            'just copy even(2.) rows (/2)
Public Const FIELD_INTEREXTEVEN = 5         'copy one even row and expend one row
Public Const FIELD_JUSTCOPYODD = 6          'just copy odd rows to odd rows
Public Const FIELD_JUSTCOPYEVEN = 7         'just copy even rows to even rows
Public Const FIELD_ODDEVENCROSS = 8         'copy odd and even crossly



'-----defines for several target we can support
'typedef LPARAM  TARGET;

Public Const BUFFER = 1           'Buffer(physical) allocated from host memory
Public Const VIDEO = 0            'Video source input to the board
Public Const SCREEN = -1          'Screen supported by VGA
Public Const FRAME = -2           'Frame buffer on the board
Public Const MONITOR = -3         'Monitor supported by (D/A) TV standard


Public Const SEQFILE = &H5153             'SQ
Public Const BMPFILE = &H4D42             'BM

Public Const BLKHEADER = &H4B42           'BK

'-----defines messages for user

Public Const WM_USER = &H400

Public Const WM_CLOSEREPLAY = WM_USER + 100
        'send this message when close replay dlg

Public Const WM_BEGINSEQPROC = WM_USER + 101
        'begin seq proc, wParam=hBaord
Public Const WM_SEQPROGRESS = WM_USER + 102
        'seq in progress, wParam=hBaord, lParam=No. to
Public Const WM_ENDSEQPROC = WM_USER + 103
        'end seq proc, wParam=hBaord

'-----------struct defines---------------

'--app user used struct
Type tpBoardType
    iBoardTypeCode As Integer  'ok board type code
    szBoardName As String * 22 'board name (eg."OK_M20H")
End Type
Public BOARDTYPE As tpBoardType
Public LPBOARDTYPE As Long  '24 bytes

'image file block size
Type tpBlockSize
    iWidth As Integer      'width
    iHeight As Integer     'height
    iBitCount As Integer   'pixel bytes iBitCount
    iFormType As Integer   'rgb format type, need to fill when RGB565 or RGB 555
    lBlockStep As Long     'block stride (step to next image header)
                           'need to fill when treat multi block else set 0
End Type
Public BLOCKSIZE As tpBlockSize

'image block info
Type tpBlockInfo
    iType As Integer   '=BK or SQ, BM
    'struct _blocksize;
    iWidth As Integer  'width
    iHeight As Integer 'height
    iBitCount As Integer  'pixel bytes iBitCount
    iFormType As Integer   'rgb format type, need to fill when RGB565 or RGB 555
    lBlockStep As Long  'block stride (step to next image header)

    lTotal As Long  'frame num
    iInterval As Integer  'frame interval
    lpBits As Long ' image data pointer / file path name
    lpExtra As Long ' extra data (like as palette, mask) pointer
End Type
Public BLOCKINFO As tpBlockInfo
Public LPBLOCKINFO As Long
Public blkUse As tpBlockInfo

'sequence file info
Type tpSeqInfo 'file info for seq
    iType As Integer   '=SQ or BM
    'struct _blocksize;
    iWidth As Integer      'width
    iHeight As Integer     'height
    iBitCount As Integer  'pixel bytes iBitCount
    iFormType As Integer   'rgb format type, need to fill when RGB565 or RGB 555
    lBlockStep As Long  'block stride (step to next image header)

    lTotal As Long  'frame num
    iInterval As Integer  'frame interval
End Type
Public SEQINFO As tpSeqInfo

'for replay
Type tpDibInfo 'file info for seq
    lpbi As Long  'bitmap info
    lpdib As Long  'dib data
    hwndPlayBox As Long  '1 replaying, 0 quit
    iCurrFrame As Integer  'current frame in buffer
End Type
Public DIBINFO As tpDibInfo
Public LPDIBINFO As Long



'------ okapi32 functions list -----------


'--1. basic routines--------------

'prolog and epilog
Declare Function okOpenBoard Lib "okapi32.dll" (iIndex As Long) As Long   'okLockBoard
        'open a Ok series board in specified index(0 based), return 0 if not found any
        'if success, return a handle to control specified board
        'if set index=-1, mean takes default index no. (default is 0
        'if user not specified by 'Ok Device Manager' in Control Pannel)
        'this index can be also a specified board type code
        'this function will change iIndex to the true used index,
        'if index input is -1 or type code

Declare Function okCloseBoard Lib "okapi32.dll" (ByVal hBoard As Long) As Boolean  'okCloseBoard
        'Unlock and close Ok board specified handle
Declare Function okGetLastError Lib "okapi32.dll" () As Long
        'Get last error msg

Declare Function okGetBufferSize Lib "okapi32.dll" (ByVal hBoard As Long, lpLinear As Long, dwSize As Long) As Long
        'get base address and size of pre-allocated buffer,
        'if success return the max. frame num in which can be store according to current set
        'else return false;
Declare Sub okGetBufferAddr Lib "okapi32.dll" (ByVal hApi As Long, ByVal iNoFrame As Integer)
        'get base address of specified frame No. in BUFFER
        'if success return the linear base address
        'else return false;

Declare Function okGetTypeCode Lib "okapi32.dll" (ByVal hBoard As Long, lpBoardName As Long) As Integer
        'return type code and name of specified handle


'set rect and capture
Declare Function okSetTargetRect Lib "okapi32.dll" (ByVal hBoard As Long, ByVal target As Long, lpTgtRect As RECT) As Long
        'set target (VIDEO, SCREEN, BUFFER, FRAME)capture to or from
        'if Rect.right or .bottom) are -1 , they will be filled current value
        'special note for target=BUFFER:
        'if never set CAPTURE_BUFBLOCKSIZE, the block size(W,H) of buffer will be changed
        'according to size of right x bottom of lpRect, else the size will not changed
        'if success return max frames this target can support, else return <=0

Declare Function okSetToWndRect Lib "okapi32.dll" (ByVal hBoard As Long, ByVal hWnd As Long) As Boolean
        'set client rect of hwnd as screen rect


Declare Function okCaptureTo Lib "okapi32.dll" (ByVal hBoard As Long, ByVal dest As Long, ByVal wParam As Integer, ByVal lParam As Long) As Boolean
        'capture video source to target which can be BUFFER, SCREEN, FRAME, MONITOR
        'wParam=start(o based), lParam>0: number of frame to capture to, =0: cont. mode,
        'if lParam > total frames in BUFER, it will loop in rewind mode(i%total)
        'if lParam=-1 mean it loop infinitely until call okStopCapture
        'return max num frame can be stored in the target if success,
        ' return 0 if failed(eg. format not matched). -1 not support target
        'this call will return immediately not wait to finish.
        '
Declare Function okCaptureToScreen Lib "okapi32.dll" (ByVal hBoard As Long) As Boolean
        'Start to capture to screen (video real-time display on screen) and return immediately
        'this is just a special routine of okCaptureTo(hBoard,SCREEN,0,0)

Declare Function okPlaybackFrom Lib "okapi32.dll" (ByVal hBoard As Long, ByVal src As Long, ByVal wParam As Integer, ByVal lParam As Long) As Boolean
        'playback on monitor from target which can be BUFFER, FRAME
        'wParam=start(o based), lParam>0: number of frame to capture to, =0: cont. mode
        'if lParam > total frames in BUFER, it will loop in rewind mode (i%total)
        'if lParam=-1 mean it loop infinitely until call okStopCapture
        'return max num frame be stored in the target if success,
        'return 0 if wrong. -1 not support target
        'this call will return immediately not wait to finish.
        '

'get status and stop capture
Declare Function okGetCaptureStatus Lib "okapi32.dll" (ByVal hBoard As Long, ByVal bWait As Boolean) As Long
        'query capturing status, if bWait then wait to finish capturing, else return immediately.
        'return 0 if finished, if cont. mode capturing return target capture to
        '(which include SCREEN -1, FRAME -2, MONITOR -3)
        'if capturing to/from BUFFER or file, return the frame No.(1 based) being capturing

Declare Function okStopCapture Lib "okapi32.dll" (ByVal hBoard As Long) As Boolean
        'Stop capturing to or playback from SCREEN, BUFFER or other targets
        'return target just captured to or from.
        'if capturing to/from BUFFER or file, return the frame No.(1 based) being capturing


'capture by to /from
Declare Function okCaptureByBuffer Lib "okapi32.dll" (ByVal hBoard As Long, ByVal dest As Any, ByVal start As Integer, ByVal num As Long) As Boolean
        'capture sequence images to dest by way of two frame buffers (in BUFFER),
        'the frame size and format is taken as same as current config of BUFFER
        'if dest is file name which can be .seq or .bmp (will generate multi bmp files)
        'dest can be also a user memory pointer or a BLOCKINFO pointer (with user memory pointer)
        'retrun true immediately if success. num should be great than 0

        
Declare Function okPlaybackByBuffer Lib "okapi32.dll" (ByVal hBoard As Long, ByVal src As Long, ByVal start As Integer, ByVal num As Long) As Boolean
        'playback sequence images on monitor from src by way of two frame buffers (in BUFFER)
        'the size and format of BUFFER will be changed to same as src
        'src can be a file name which may be .seq or .bmp (first orderd bmp files)
        ''src can be also a BLOCKINFO pointer (with infos of user memory pointer,size and format)
        'if src is just user memory pointer, this function will think its block size and format
        'are same as current config of BUFFER (in this case can not support loop function).
        'retrun true immediately if success
        'if num is great than the true frame number in src, it will loop back
        'if num=-1 mean it will loop infinitely until call okStopCapture

'set and get params
Declare Function okSetVideoParam Lib "okapi32.dll" (ByVal hBoard As Long, ByVal wParam As Integer, ByVal lParam As Long) As Long
        '----set video param sub-function defines
        'set video param and return previous param;
        'if input lParam=-1, just return previous param
        'if not support return -1, if error return -2

Declare Function okSetCaptureParam Lib "okapi32.dll" (ByVal hBoard As Long, ByVal wParam As Integer, ByVal lParam As Long) As Long
        'set capture param and return previous param;
        'if input lParam=-1, just return previous param
        'if not support return -1, if error return -2


'transfer and convert rect
Declare Function okSetConvertParam Lib "okapi32.dll" (ByVal hBoard As Long, ByVal wParam As Integer, ByVal lParam As Long) As Long
        'set convert param for for function okConvertRect
        'if not support return -1, if error return -2

Declare Function okReadRect Lib "okapi32.dll" (ByVal hApi As Long, ByVal src As Long, ByVal start As Integer, lpBuf As Long) As Long
        'read data into lpBuf from rect(set previous) in frame start of dst (SCREEN, BUFFER, FRAME)
        'the data in lpBuf stored in way row by row
        'if src not supported return -1, if failed return 0,
        'return -1 if not support, return 0 failed,
        'if success return data length read in byte
        'if lpBuf=NULL, just return data length to read

Declare Function okWriteRect Lib "okapi32.dll" (ByVal hApi As Long, ByVal dst As Long, ByVal start As Integer, lpBuf As Long) As Long
        'write data in lpBuf to rect(set previous) of dst (SCREEN, BUFFER, FRAME)
        'the data in lpBuf stored in way row by row
        'return -1 if not support, return 0 failed,
        'if success return data length written in byte

Declare Function okTransferRect Lib "okapi32.dll" (ByVal hBoard As Long, dest As Any, ByVal iFirst As Integer, ByVal src As Long, ByVal iStart As Integer, ByVal lNum As Long) As Long
        'transfer source rect to dest rect (here target can be SCREEN, BUFFER, FRAME, also BLOCKINFO point to user memory)
        'if total in dest or src less than lNum, it will rewind to begin then continue
        'this function transfer in format of src, that means it don't convert pixel bits if dst and src are not same
        'if src or dst not supported return -1, if failed return 0,
        'if success return data length of one block image in byte

Declare Function okConvertRect Lib "okapi32.dll" (ByVal hApi As Long, dst As Any, ByVal first As Integer, ByVal src As Long, ByVal start As Integer, ByVal no As Long) As Long
        'transfer source rect to dest rect (here target can be SCREEN, BUFFER, FRAME, also BLOCKINFO point to user memory)
        'if total in dest or src < lNum, it will rewind to begin then continue
        'this function convert to pixel foramt of dst if dst has not same bits format as src
        'if src or dst not supported return -1, if failed return 0,
        'if success return image size of one block in pixel


    
Declare Function okGetSignalParam Lib "okapi32.dll" (ByVal hBoard As Long, ByVal wParam As Long) As Long
        'Get specified param of video signal source
        'if not support return -1, if error return -2, else return param

Declare Function okWaitSignalEvent Lib "okapi32.dll" (ByVal hBoard As Long, ByVal wParam As Long, ByVal lMilliSecond As Long) As Long
        'Wait specified signal come
        'lMilliSecond is time-out time in milliseconds for to wait
        'if lMilliSecond is zero, the function returns current state immediately
        'if lMilliSecond is INFINITE(-1) wait forever until event come
        'return -1 not support, 0 speicfied signal not come, 1 come


Declare Function okSetSeqProcWnd Lib "okapi32.dll" (ByVal hBoard As Long, ByVal hwndMain As Long) As Boolean
        'set proc hwnd for receive message about sequence capture

Declare Function okSetSeqCallback Lib "okapi32.dll" (ByVal hBoard As Long, ByVal BeginProc As Long, ByVal SeqProc As Long, ByVal EndProc As Long) As Boolean
        'set callback function for multi-frame capturing function
        '(which are okCaptureTo, okCaptureFrom,okCaptureToFile, okCaptureFromFile)
        'see follow

''BOOL    CALLBACK BeginProc(HANDLE hBoard); 'user defined callback function
        'callback this function before to capture
''BOOL    CALLBACK SeqProc(HANDLE hBoard, long No); 'user defined callback function
        ' callback this function after finish capturing one frame
        ' No is the number(0 based) frame just finished or being playbacked.
''BOOL    CALLBACK EndProc(HANDLE hBoard); 'user defined callback function
        ' callback this function after end capturing

'---overlay mask:
Declare Function okEnableMask Lib "okapi32.dll" (ByVal hBoard As Long, ByVal bMask As Boolean) As Long
        '0: disable mask; 1: positive mask, 2: negative mask
        'positive: 0 for win clients visible, 1 video visible
        'negative: 0 for video visible,  1 for win client (graph) visible
        'if bMask=-1 actually not set just get status previous set
        'return last mask status,
 
Declare Function okSetMaskRect Lib "okapi32.dll" (ByVal hBoard As Long, lpRect As Long, lpMask As String) As Long
        'Set mask rect(lpRect is relative to lpDstRect in SetScreenRect or
        'SetBufferRect, lpMask is mask code (in byte 0 or 1). one byte for one pixel
        'if lpMask==1, set all rect region in lpRect video visible
        'if lpMask==0, set all rect region in lpRect video unvisible
        'return base linear address of inner mask bit

'---set out LUT:
Declare Function okFillOutLUT Lib "okapi32.dll" (ByVal hBoard As Long, bLUT As Long, ByVal start As Integer, ByVal num As Integer) As Long
        'fill specified playback out LUT.
        'bLut stored values to fill, (r0,g0,b0, r1,g1,b1 ...)
        'start: offset pos in LUT(based 0), num: num items to fill


'---multi cards access--------
Declare Function okGetSlotBoard Lib "okapi32.dll" (lpOkInfo As Any) As Integer
        'Query all Ok boards available in PCI bus, return total number
Declare Function okGetBoardIndex Lib "okapi32.dll" (szBoardName As String, ByVal iNo As Integer) As Integer
        'Get index (start 0) of specified board name string (it can also be typcode string)
        ' and order in same name (start 0),
        'return -1 if no this specified ok board


Declare Function okGetAvailBuffer Lib "okapi32.dll" (lpLinear As Long, dwSize As Long) As Long
        'Get free meomery buffers pre-allocated .
        'call it when user hope to access buffer directly or lock for one board
Declare Function okLockBuffer Lib "okapi32.dll" (ByVal hBoard As Long, ByVal dwSizeByte As Long, lpBasLinear As Long) As Long
        'Lock speicfiled size meomery buffers, then other handle can not use
Declare Function okUnlockAllBuffer Lib "okapi32.dll" () As Boolean
        'Unlock all buffer

'-- set pre-allocate buffer size in k byte
Declare Function okSetAllocBuffer Lib "okapi32.dll" (ByVal dwSize As Long) As Long


'---apps utilities-----------------

'save and load files
Declare Function okSaveImageFile Lib "okapi32.dll" (ByVal hBoard As Long, szFileName As String, ByVal first As Long, ByVal target As Long, ByVal start As Long, ByVal num As Long) As Long
    'here target can be BUFFER, SCREEN, FRAME or user buffer pointor
    '1.if ext name=".bmp":
    'create new file and than save one frame in start position of target as bmp file
    '
    '2.if ext name=".seq":
    'save no frame from (start) in target into (first) frame pos in seq(sequence) file in sequencely.
    'if the file already exist the function will not delete it, that mean old contents in the file will be kept.
    'So if you want create a new seq file with a existed file name you must delete before this call .
    '

Declare Function okLoadImageFile Lib "okapi32.dll" (ByVal hBoard As Long, szFileName As String, ByVal first As Long, ByVal target As Long, ByVal start As Long, ByVal num As Long) As Long
    'here target can be BUFFER, SCREEN, FRAME or user buffer pointor
    '1.if ext name=".bmp":
    'load one frame into start position of target from bmp file
    '
    '2.if ext name=".seq":
    'load no frame into (start) in target from (first) frame pos in seq(sequence) file in sequencely.



'apps setup dialog
Declare Function okOpenSetParamDlg Lib "okapi32.dll" (ByVal hBoard As Long, ByVal hParentWnd As Long) As Boolean
    'dialog to setup video param
Declare Function okOpenSeqCaptureDlg Lib "okapi32.dll" (ByVal hBoard As Long, ByVal hParentWnd As Long) As Boolean
    'dialog to capture sequence image

Declare Function okOpenReplayDlg Lib "okapi32.dll" (ByVal hBoard As Long, ByVal hWnd As Long, ByVal src As Any, ByVal total As Long) As Long
    'open modeless dialog to replay sequence images(in BUFFER, USERBUF or seq file) on SCREEN or MONITOR


'-------------------end--------------------------





